<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db
 */
/**
 * @file Database.php
 * @brief database abstract layer
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: Database.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * database abstract layer
 */

require_once "ficus/db/DatabaseConstants.php";

/**
 * @class Ficus_Database
 */
abstract class Ficus_Database implements Ficus_DatabaseConstants
{
    /**
     * connect to server
     * @param $dns String data source
     * @param $user String user name
     * @param $pass String password
     * @throw Soya_SQLException database error.
     */
    public abstract function connect($dsn, $user = null, $pass = null);

    /**
	 * execute query
	 * @param $query String query
	 * @param $parameters array paramters
	 * @return query result
     * @throw Soya_SQLException database error.
	 */
    public abstract function query($query, $parameters = array());

    /**
     * disconnect
     */
    public abstract function disconnect();

    /**
     * create dsn from parameter
     * @param $type String type of database
     * @param $host String host name
     * @param $dbname String database name
     * @return String dsn
     */
    public function createDSN($type, $host, $dbname){
        return "$type:database=$dbname:host=$host";
    }

    /**
     * begin transaction
     */
    public abstract function begin();
 
    /**
     * end transaction
     */
    public abstract function commit();

    /**
     * rollBack transaction
     */
    public abstract function rollBack();

    /**
     * is connected
     * @throw Ficus_NotReadyException not connected
     */
    public abstract function isConnected();

    /**
     * has error
     * @return boolean there are some error, return true
     */
    public abstract function hasError();
}
?>
