<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.db.s2dao.models
 */
/**
 * @file S2DaoEntity.php
 * @brief S2DaoEntity.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: S2DaoEntity.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/lang/Class.php");
require_once("ficus/beans/Bean.php");
require_once("ficus/db/s2dao/models/S2DaoEntity.php");
require_once("ficus/db/s2dao/models/S2DaoModelConstants.php");

/**
 * @class Ficus_S2DaoEntity
 */
abstract class Ficus_S2DaoEntity extends Ficus_Bean implements Ficus_S2DaoModelConstants{
    /**
     * get entity name
     */
    public function getEntityName(){
        $class = get_class($this);
        if(preg_match('/_(Auto)?(.*)Entity$/', $class, $regs)){
            return $regs[2];
        }
        return $class;
    }
    
    /**
     * cast class
     * @param $from Ficus_S2DaoEntity entity
     * @to $to string subject name
     */
    protected function convert($from, $to, $auto = false){
        if(is_null($from)){
            return null;
        }
        if(is_object($to)){
            $to = get_class($to);
        }
        $temp = Ficus_Dao::getEntityWithSubject($to, $auto);
        return Ficus_Class::cast($from, $temp);
    }

    /**
     * recursive update method
     */
    public function update(){
        $reader = new Ficus_S2DaoEntityAnnotationReader($this);
        $properties = $reader->properties();
        if(count($properties) == 1){
            return 0;
        }
        $dao = $this->dao();
        $dao->update($this);
        foreach($properties as $property){
            if($reader->type($property) == self::TYPE_FOREIGN){
                $getter = "get" . ucfirst($property);
                $value = $this->{$getter}();
                $id = $value->id();
                if(is_null($id)){
                    continue;
                }
                $value->update();
            }
        }
    }

    /**
     * recursive update method
     */
    public function insert(){
        $reader = new Ficus_S2DaoEntityAnnotationReader($this);
        $properties = $reader->properties();
        foreach($properties as $property){
            if($reader->type($property) != self::TYPE_FOREIGN){
                continue;
            }
            $getter = "get" . ucfirst($property);
            $setter = "set" . ucfirst($property) . "Direct";
            $value = $this->{$getter}();

            if($value->isBlank() == false){
                $value->insert();
                $this->{$setter}($value->id());
            }
        }

        $dao = $this->dao();
        $dao->insert($this);
    }

    /**
     * get dao
     * @return Dao
     */
    abstract public function dao();
}
?>
