<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file HierarchicalURI.php
 * @brief Hierarchical URI for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: HierarchicalURI.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * URI for php
 */
require_once("ficus/net/URI.php");
require_once("ficus/net/URIBuilder.php");
require_once("ficus/lang/Assert.php");
/**
 * @class Ficus_HierarchicalURI
 */
class Ficus_HierarchicalURI extends Ficus_URI {

    /**
     * Constructor.
     *
     * @param $uri mixed URI to be parsed.
     */
    public function __construct($uri) {
        parent::__construct($uri);
    }

    /**
     * Parse URL.
     */
    protected function parse() {
        parent::parse();
        if (is_null($this->authority)) {
            if ($this->isAbsolute() && $this->path{0} != '/') {
                throw new Ficus_URISyntaxException('No Hierarchical URI. ' . $this->uri);
            }
        }
    }

    /**
     * Is absolute URI.
     *
     * Relative URI has not scheme.
     *
     * @return boolean true if absolute URL.
     */
    public function isAbsolute() {
        return !is_null($this->getScheme());
    }

    /**
     * Normalize URI.
     *
     * @return Ficus_URI URI.
     */
    public function normalize() {
        $normalizedPath = Ficus_Dir::normalizePath($this->getPath());
        $uri = $this->getScheme() . $this->getAuthority() . $normalizedPath;
        $uri .= '?' . $this->getQuery() . '#' . $this->getFragment();
        return self::create($uri);
    }
}
?>
