<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file PageComponentFactory.php
 * @brief Page component factory
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PageComponentFactory.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Page component factory
 */

require_once("smarty/Smarty.class.php");
require_once("ficus/io/File.php");
require_once("ficus/config/Registry.php");
require_once("ficus/lang/AutoLoad.php");
require_once("ficus/lang/S2ContainerAutoLoad.php");
require_once("ficus/lang/ClassLoaderAutoLoad.php");
require_once("ficus/pages/PageController.php");
require_once("ficus/pages/InlinePageController.php");
require_once("ficus/pages/PageLoader.php");
require_once("ficus/pages/PageTemplateLoader.php");
require_once("ficus/pages/PageConstants.php");
require_once("ficus/pages/beans/PageEnvironmentsBean.php");
require_once("ficus/pages/beans/PageVisitBean.php");
require_once("ficus/lang/Array.php");

/**
 * @class Ficus_PageComponentFactory
 */
class Ficus_PageComponentFactory implements Ficus_PageConstants{

    /**
     * Default dicon file name.
     */
    const DEFAULT_DICON_FILE = 'pages.dicon';

    /**
     * dicon namespace.
     */
    const DICON_NAMESPACE = 'pages.scheme';

    /**
     * @var S2Container S2Container.
     */
    private static $container = null;

    /**
     * Get dicon path.
     *
     * return string dicon path..
     */
    private static function getDiconPath() {
        $diconPath = Ficus_Registry::search("pages.dicon");
        if($diconPath == false){
            $diconPath = Ficus_File::currentDir()
                ->resolve(self::DEFAULT_DICON_FILE)->getPath();
        }
        
        return $diconPath;
    }

    /**
     * check registry
     */
    private static function checkRegistry(){
        if(Ficus_Registry::search(self::REGISTRY_SMARTY) == false){
            throw new Ficus_PropertyNotFoundException("property " . self::REGISTRY_SMARTY . " must be loaded before ComponentFactory initialization");
        }else if(Ficus_Registry::search(self::REGISTRY_BASE) == false){
            throw new Ficus_PropertyNotFoundException("property " . self::REGISTRY_BASE . " must be loaded before ComponentFactory initialization");
        }else if(Ficus_Registry::search(self::REGISTRY_PREFIXES) == false){
            throw new Ficus_PropertyNotFoundException("property " . self::REGISTRY_PREFIXES . " must be loaded before ComponentFactory initialization");
        }

        if(Ficus_Registry::search(self::REGISTRY_SMARTY_PROPERTIES) == false){
            Ficus_Registry::regist(self::REGISTRY_SMARTY_PROPERTIES,
                                  self::DEFAULT_SMARTY_PROPERTIES);
        }
        if(Ficus_Registry::search(self::REGISTRY_SMARTY_PLUGINS) == false){
            Ficus_Registry::regist(self::REGISTRY_SMARTY_PLUGINS,
                                  self::DEFAULT_SMARTY_PLUGINS);
        }
        if(Ficus_Registry::search(self::REGISTRY_SMARTY_ENV) == false){
            Ficus_Registry::regist(self::REGISTRY_SMARTY_ENV,
                                  self::DEFAULT_SMARTY_ENV);
        }
        if(Ficus_Registry::search(self::REGISTRY_SMARTY_VISIT) == false){
            Ficus_Registry::regist(self::REGISTRY_SMARTY_VISIT,
                                  self::DEFAULT_SMARTY_VISIT);
        }
        if(Ficus_Registry::search(self::REGISTRY_DEFAULT) == false){
            Ficus_Registry::regist(self::REGISTRY_DEFAULT,
                                  self::DEFAULT_DEFAULT);
        }
        if(Ficus_Registry::search(self::REGISTRY_SUFFIX) == false){
            Ficus_Registry::regist(self::REGISTRY_SUFFIX,
                                  self::DEFAULT_SUFFIX);
        }
        if(Ficus_Registry::search(self::REGISTRY_INLINE_SUFFIX) == false){
            Ficus_Registry::regist(self::REGISTRY_INLINE_SUFFIX,
                                  self::DEFAULT_INLINE_SUFFIX);
        }
    }

    /**
     * Get S2Container.
     *
     * return S2Container S2Container.
     */
    private static function getS2Container() {
        if (self::$container == null) {
            self::checkRegistry();
            $diconPath = self::getDiconPath();
            self::$container = S2ContainerFactory::create($diconPath);
            Ficus_AutoLoad::add(new Ficus_S2ContainerAutoLoad());
        }
        return self::$container;
    }

    /**
     * get component
     *
     * @return component
     */
    public static function getComponent($name){
        return self::getS2Container()->getComponent($name);
    }

    /**
     * get Smarty
     * @return Smarty smarty view controller
     */
    public static function getSmarty(){
        return self::getComponent(self::COMPONENT_SMARTY);
    }

    /**
     * get template loader
     * @return Ficus_PageTemplateLoader template loader
     */
    public static function getTemplateLoader(){
        return self::getComponent(self::COMPONENT_TEMPLATELOADER);
    }

    /**
     * get page loader
     * @return Ficus_PageLoader page loader
     */
    public static function getPageLoader(){
        return self::getComponent(self::COMPONENT_PAGELOADER);
    }

    /**
     * get page controller
     * @return Ficus_PageController controller
     */
    public static function getPageController(){
        return self::getComponent(self::COMPONENT_PAGECONTROLLER);
    }

    /**
     * get page loader
     * @return Ficus_PageLoader page loader
     */
    public static function getInlinePageLoader(){
        return self::getComponent(self::COMPONENT_INLINEPAGELOADER);
    }

    /**
     * get inline page controller
     * @return Ficus_InlinePageController controller
     */
    public static function getInlinePageController(){
        return self::getComponent(self::COMPONENT_INLINEPAGECONTROLLER);
    }

    /**
     * get environment bean
     * @return Ficus_PageEnvironmentsBean
     */
    public static function getEnvBean(){
        return self::getComponent(self::COMPONENT_ENVBEAN);
    }

    /**
     * get visit bean
     * @return Ficus_PageVisitBean
     */
    public static function getVisitBean(){
        return self::getComponent(self::COMPONENT_VISITBEAN);
    }
    
    /**
     * Get Authentication
     */
    public static function getAuthorization($page){
        Ficus_Assert::isInstanceOf($page, "Ficus_Page");
        $name = $page->getPagename() . "PageAuthorization";
        return self::getComponent($name);
    }
}
?>
