<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file PageVisitBean.php
 * @brief Page session bean
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PageVisitBean.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Page component factory
 */

require_once("ficus/beans/Bean.php");

/**
 * @class Ficus_PageVisitBean
 */
class Ficus_PageVisitBean extends Ficus_Bean
implements S2AnA_AuthenticationContext, Ficus_PageConstants{
    /**
     * environments
     */
    protected $request;

    /**
     * user name
     */
    protected $user;

    /**
     * password
     */
    protected $password;

    /**
     * constructor
     */
    public function __construct(){
        $this->getUserPrincipal();
    }

    /**
     * is guest
     * @return boolean true if guest
     */
    public function isGuest(){
        return ($this->user === self::USER_GUEST);
    }

    /**
     * is logined
     * @return boolean true if logined
     */
    public function isLogined(){
        return ($this->isGuest() === false);
    }

    /**
     * user authentication
     */
    public function getUserPrincipal(){
        $this->request = $_REQUEST;
        if(isset($_SERVER[self::KEY_USER])){
            $this->user = $_SERVER[self::KEY_USER];
            $this->password = $_SERVER[self::KEY_PASSWORD];
        }else{
            session_start();
            if(isset($_SESSION[self::KEY_USER])){
                $this->user = $_SESSION[self::KEY_USER];
            }else{
                $this->user = self::USER_GUEST;
            }
        }
    }

    /**
     * is authenticated
     */
    public function isAuthenticated(){
        return $this->isLogined();
    }

    /**
     * is user in role
     */
    public function isUserInRole($roleName){
        return true;
    }
}
?>
