<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file ScaffoldTableConfiguration.php
 * @brief ScaffoldTableConfiguration.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldTableConfiguration.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

/**
 * @class Ficus_ScaffoldTableConfiguration
 */
class Ficus_ScaffoldTableConfiguration extends Ficus_Bean
implements Ficus_ScaffoldConstants, Ficus_S2DaoModelConstants{
    /**
     * exclude pattern
     */
    protected $excludes = array();

    /**
     * no label
     */
    protected $nolabels = array();

    /**
     * no children
     */
    protected $noChildren = true;

    /**
     * transitions
     */
    protected $transitions = array();

    /**
     * current Transition
     */
    protected $currentTransition = array();

    /**
     * default values
     */
    protected $defaultValues = array();

    /**
     * check for exclude
     * @param $part Ficus_ScaffoldPart part to check
     */
    public function isExcludeProperty($part){
        $entityName = $this->getQname($part);
        if((isset($this->excludes["*"]) &&
            in_array($part->name(), $this->excludes["*"])) ||
           (isset($this->excludes[$entityName]) &&
            in_array($part->name(), $this->excludes[$entityName])) ||
           (isset($this->excludes[$entityName]) &&
            $this->excludes[$entityName][0] == "*")){
            return true;
        }
        return false;
    }

    /**
     * check for exclude
     * @param $part Ficus_ScaffoldPart part to check
     */
    public function isNoLabelProperty($part){
        $entityName = $this->getQname($part);
        if(array_key_exists($entityName, $this->nolabels) &&
           $this->nolabels[$entityName] == $part->name()){
            return true;
        }
        return false;
    }

    /**
     * check for transition property
     * @param $part Ficus_ScaffoldPart part to check
     */
    public function isTransitionProperty($part){
        $entityName = $this->getQname($part);

        if(empty($this->currentTransition)){
            return true;
        }
        if($part->value() instanceof Ficus_S2DaoEntity &&
           in_array($this->getEntityQname($part), $this->currentTransition)){
            return true;
        }
        if(in_array($entityName, $this->currentTransition) == false){
            return false;
        }

        return true;
    }

    /**
     * check is parent of transition property
     */
    public function isTransitionParentProperty($part){
        if($part->type() == self::TYPE_FOREIGN){
            $parent = $this->getEntityQname($part);
            foreach($this->currentTransition as $transition){
                if(strpos($transition, $parent) === 0){
                    return true;
                }
            }
        }
        return false;            
    }
    
    /**
     * get default value
     * @param $part Ficus_ScaffoldPart part to check
     */
    public function getDefaultValue($part){
        if($part->type() != self::TYPE_LIST &&
           $part->type() != self::TYPE_DIRECT){
            return null;
        }
        $qname = $this->getQname($part) . "." . $part->name();
        if(preg_match('/Direct$/', $qname) == false){
            $qname .= "Direct";
        }
        if(isset($this->defaultValues[$qname])){
            return $this->defaultValues[$qname];
        }
        return null;
    }

    /**
     * is no children
     */
    public function isNoChildren(){
        return $this->noChildren;
    }

    /**
     * ignore parts pattern
     * @param $entityname string ignore entity name
     * @param $property string when null, ignore class
     */
    public function addExcludeProperty($entityname, $property = null){
        $this->excludes[$entityname][] = $property;
    }

    /**
     * no label pattern
     */
    public function addNoLabelProperty($entityname, $property = null){
        $this->nolabels[$entityname] = $property;
    }

    /**
     * set no children
     * @param $noChildren boolean set to true, ignore child entities
     */
    public function setNoChildren($noChildren){
        $this->noChildren = $noChildren;
    }

    /**
     * set transition
     * @param $transition string transition
     */
    public function setCurrentTransition($transition){
        $transition = explode(",", $transition);
        $this->currentTransition = array();
        foreach($transition as $trans){
            $this->currentTransition[] = trim($trans);
        }
    }

    /**
     * set transitions
     * @param $transitions array transitions
     */
    public function setTransitions($transitions){
        $this->transitions = $transitions;
    }

    /**
     * set default values
     */
    public function addDefaultValues($column, $value){
        $this->defaultValues[$column] = $value;
    }
    

    /**
     * get qname
     */
    protected function getQname($part){
        $entityName = $part->entity()->getEntityName();
        if($part->hasParent()){
            $entityName = $this->getQname($part->parent()) . "." . $entityName;
        }
        return $entityName;
    }

    /**
     * get Entity qname
     */
    protected function getEntityQname($part){
        if(($part->value() instanceof Ficus_S2DaoEntity) == false){
            return "";
        }
        
        $entityName = $part->value()->getEntityName();
        $qname = $this->getQname($part);
        return $qname . "." . $entityName;
    }

    /**
     * get Next transition
     * @param $key string current transition, if ommited, return first one
     * @return string next transition
     */
    public function getNextTransition($key = null){
        $transitions = $this->transitions;
        if(empty($transitions)){
            return false;
        }
        if(is_null($key)){
            return array_shift($transitions);
        }else{
            reset($transitions);
            while($value = each($transitions)){
                if($value["value"] == $key){
                    $next = each($transitions);
                    if($next == false){
                        return false;
                    }
                    return $next["value"];
                }
            }
        }
        return false;
    }
}
?>
