<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.util
 */
/**
 * @file TableManagerProxy.php
 * @brief TableManagerProxy.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: TableManagerProxy.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */

require_once("ficus/beans/Bean.php");
require_once("ficus/db/s2dao/models/S2DaoModelConstants.php");

/**
 * @class Ficus_TableManagerProxy
 */
class Ficus_TableManagerProxy extends Ficus_Bean{
    /**
     * @var entity entity
     */
    protected $entity;
    
    /**
     * get form.
     * @param $table string target table name
     * @return string form html
     */
    public function getForm($table, $mode){
        $controller =
            Ficus_PageComponentFactory::getPageController();
        if($this->isEmptyEntity() == false){
            $form = $controller->execute("common.TableManager", $mode, true,
                                         array("table" => $table),
                                         array("inline" => "inline"),
                                         array("entity" => $entity));
        }else{
            $form = $controller->execute("common.TableManager", $mode, true,
                                         array("table" => $table),
                                         array("inline" => "inline"));
        }
            
        return $form;
    }

    /**
     * change Action and Mode
     * @param $form string form
     * @param $nextAction string next action
     * @return string normalized form
     */
    public function normalizeForm($form, $pagename, $nextAction){
        $form = preg_replace('/action=".*?"/',
                             "action=\"?$pagename\"", $form);
        $form = preg_replace('/type="submit" name=".*?"/', "type=\"submit\" name=\"$nextAction\"", $form);
        return $form;
    }
}
?>
