<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.parameters.datatypes
 */
/**
 * @file ByteParameter.php
 * @brief ByteParameter for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: ByteParameter.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * ValidatableSimpleParameter with normailizer.
 * treat param as byte
 */

require_once("ficus/exception/ValidationException.php");
require_once("ficus/parameters/ValidatableSimpleParameter.php");

/**
 * @class Ficus_ByteParameter
 */
class Ficus_ByteParameter extends Ficus_ValidatableSimpleParameter
{
	const TYPENAME = "byte";

	/**
 	 * construct parameter with name, value, and specific validator.
 	 * @param $name string name of this parameter.
 	 * @param $value string value of this parameter.
 	 * @param $validator array array of Ficus_Validator.
 	 */
 	public function __construct($name, $value = null, $validator = array()){
		parent::__construct($name, self::TYPENAME, $value);
		$this->setValidator($validator);
	}

	/**
	 * check param that associated with simple parameter
	 * -128 <= x <= 127
	 * @param $parameter array data
	 * @return array validated param
     * @throw Ficus_ValidationException invalidate parameter.
	 */
	public function validate($parameter){
		$value = trim($parameter["value"]);
		if(empty($value) ||
		   (is_numeric($value) &&
				((integer)$value >= -128 && (integer)$value <= 127))){
			$parameter["value"] = $value;
			parent::validate($parameter);
		}else{
			throw new Ficus_ValidationException("Parameter {$this->name()} is not a byte range value");
		}

	}
}
?>
