<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file SmartyComponentFactory.php
 * @brief Smarty component factory
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: SmartyComponentFactory.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Smarty component factory
 */

require_once("ficus/io/File.php");
require_once("ficus/config/Registry.php");

/**
 * @class Ficus_SmartyComponentFactory
 */
class Ficus_SmartyComponentFactory extends Ficus_S2ContainerComponentFactory{

    const KEY_SMARTY = "Smarty";
    
    /**
     * dicon file name registry key
     */
    const REGISTRY_DICON_FILENAME = "smarty.dicon";

    /**
     * dicon namespace registry key
     */
    const REGISTRY_DICON_NAMESPACE = "smarty.namespace";
    
    /**
     * Default dicon file name.
     */
    const DEFAULT_DICON_FILENAME = 'ssmarty.dicon';

    /**
     * dicon namespace.
     */
    const DEFAULT_DICON_NAMESPACE = 'smarty.scheme';
    
    /**
     * get Dicon file name from registry
     * @return string dicon filename
     */
    protected function getDiconFileNameRegistry(){
        return self::REGISTRY_DICON_FILENAME;
    }

    /**
     * get Dicon namespace from registry
     * @return string dicon namespace
     */
    protected function getDiconNameSpaceRegistry(){
        return self::REGISTRY_DICON_NAMESPACE;
    }

    /**
     * get dicon file name
     * @return string dicon file name
     */
    protected function getDefaultDiconFileName(){
        return Ficus_File::currentDir()
            ->resolve(self::DEFAULT_DICON_FILENAME)->getPath();
    }
    
    /**
     * get defoult dicon namespace
     * @return string dicon namespace
     */
    protected function getDefaultDiconNameSpace(){
        return self::DEFAULT_DICON_NAMESPACE;
    }

    /**
     * get component
     * @param $name string name of component
     * @param $class string class name
     * @return Ficus_SmartyComponentFactory
     */
    public static function getComponent($name, $class = __CLASS__){
        return parent::getComponent($name, $class);
    }
    
    /**
     * Get smarty
     *
     * @param $name string component name.
     * @return mixed component.
     */
    public static function getSmarty() {
        return self::getComponent(self::KEY_SMARTY);
    }
}
?>
