/*
 * Decompiled with CFR 0.152.
 */
package filebookmarker.dialog;

import filebookmarker.bean.Bookmark;
import filebookmarker.bean.Category;
import filebookmarker.util.ElementType;
import filebookmarker.util.FileBookmarkUtil;
import filebookmarker.util.XmlAccessor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class AddDialog
extends Dialog {
    private String name = "";
    private String path = "";
    private Text txtName = null;
    private Tree tree = null;
    private final int CREATE_ID = 100;
    private Category rootCategory;

    public AddDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Point getInitialSize() {
        return new Point(300, 300);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\u30d6\u30c3\u30af\u30de\u30fc\u30af\u306b\u8ffd\u52a0");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("\u540d\u524d:");
        this.txtName = new Text(composite, 2052);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.setText(this.name);
        Label folderLabel = new Label(composite, 0);
        folderLabel.setText("\u4f5c\u6210\u5148:");
        this.tree = new Tree(composite, 2052);
        this.tree.setLayoutData((Object)new GridData(1808));
        TreeItem parentItem = new TreeItem(this.tree, 0);
        this.rootCategory = XmlAccessor.readXml();
        parentItem.setText(this.rootCategory.getName());
        parentItem.setImage(this.getImage());
        parentItem.setData((Object)this.rootCategory);
        this.tree.setSelection(parentItem);
        this.setTreeItem(parentItem, this.rootCategory);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 100, "\u65b0\u3057\u3044\u30ab\u30c6\u30b4\u30ea", false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        InputDialog newDialog;
        if (buttonId == 0) {
            String inputName = this.txtName.getText();
            if (inputName == null || "".equals(inputName)) {
                inputName = this.name;
            }
            TreeItem selectItem = this.tree.getSelection()[0];
            Category category = (Category)selectItem.getData();
            Bookmark bookmark = new Bookmark(inputName, this.path);
            category.addChild(bookmark);
            XmlAccessor.writeXml();
            this.setReturnCode(buttonId);
            this.close();
        } else if (buttonId == 100 && (newDialog = FileBookmarkUtil.getCreateCategoryDialog()).open() == 0) {
            TreeItem item = this.tree.getSelection()[0];
            TreeItem newItem = new TreeItem(item, 0);
            newItem.setText(newDialog.getValue());
            newItem.setImage(this.getImage());
            Category category = new Category(newDialog.getValue());
            newItem.setData((Object)category);
            Category selectCategory = (Category)item.getData();
            selectCategory.addChild(category);
            this.tree.setSelection(newItem);
        }
        super.buttonPressed(buttonId);
    }

    private void setTreeItem(TreeItem parentTree, Category category) {
        if (!category.hasChildren()) {
            return;
        }
        Bookmark[] bookmarkArray = category.getChildren();
        int n = 0;
        int n2 = bookmarkArray.length;
        while (n < n2) {
            Bookmark childCategory = bookmarkArray[n];
            if (childCategory.getType() == ElementType.CATEGORY) {
                TreeItem childTree = new TreeItem(parentTree, 0);
                childTree.setData((Object)childCategory);
                childTree.setText(childCategory.getName());
                childTree.setImage(this.getImage());
                this.setTreeItem(childTree, (Category)childCategory);
            }
            ++n;
        }
    }

    private Image getImage() {
        return FileBookmarkUtil.getCategoryCloseImg();
    }

    public void setBookmarkName(String name) {
        this.name = name;
    }

    public void setBookmarkPath(String path) {
        this.path = path;
    }
}

