/*
 * Decompiled with CFR 0.152.
 */
package filebookmarker.util;

import filebookmarker.Activator;
import filebookmarker.bean.Bookmark;
import filebookmarker.bean.Category;
import filebookmarker.bean.RootCategory;
import filebookmarker.util.ElementType;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlAccessor {
    private static Category rootCategory;
    private static String path;

    static {
        path = null;
        path = String.valueOf(Activator.getDefault().getStateLocation().toString()) + File.separator + "mybookmark.xml";
    }

    public static Category readXml() {
        if (rootCategory != null) {
            return rootCategory;
        }
        try {
            File file = new File(path);
            if (!file.exists()) {
                file = XmlAccessor.createXml(path);
            }
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(file);
            Element root = doc.getDocumentElement();
            rootCategory = new RootCategory(root.getTagName());
            XmlAccessor.setChildNode(root.getChildNodes(), rootCategory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootCategory;
    }

    public static void writeXml() {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docbuilder = dbfactory.newDocumentBuilder();
            Document document = docbuilder.newDocument();
            Element root = document.createElement(rootCategory.getName());
            XmlAccessor.setElement(rootCategory, document, root);
            document.appendChild(root);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer();
            File outfile = new File(path);
            transformer.transform(new DOMSource(document), new StreamResult(outfile));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static Category getRootCategory() {
        if (rootCategory == null) {
            XmlAccessor.readXml();
        }
        return rootCategory;
    }

    private static void setElement(Category rootCategory, Document document, Element root) {
        Bookmark[] bookmarkList;
        if (!rootCategory.hasChildren()) {
            return;
        }
        Bookmark[] bookmarkArray = bookmarkList = rootCategory.getChildren();
        int n = 0;
        int n2 = bookmarkArray.length;
        while (n < n2) {
            Bookmark bookmark = bookmarkArray[n];
            if (bookmark.getType() == ElementType.CATEGORY) {
                Element childElement = document.createElement("category");
                childElement.setAttribute("name", bookmark.getName());
                root.appendChild(childElement);
                XmlAccessor.setElement((Category)bookmark, document, childElement);
            } else if (bookmark.getType() == ElementType.BOOKMARK) {
                Element childFileElement = document.createElement("file");
                childFileElement.setAttribute("name", bookmark.getName());
                childFileElement.setAttribute("path", bookmark.getPath());
                root.appendChild(childFileElement);
            }
            ++n;
        }
    }

    private static void setChildNode(NodeList nodeList, Category parentCategory) {
        if (nodeList == null) {
            return;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            String name = element.getAttribute("name");
            if ("category".equals(element.getNodeName())) {
                Category childCategory = new Category(name);
                parentCategory.addChild(childCategory);
                XmlAccessor.setChildNode(element.getChildNodes(), childCategory);
            } else if ("file".equals(element.getNodeName())) {
                String path = element.getAttribute("path");
                parentCategory.addChild(new Bookmark(name, path));
            }
            ++i;
        }
    }

    private static File createXml(String path) throws URISyntaxException, IOException, TransformerException, ParserConfigurationException {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docbuilder = dbfactory.newDocumentBuilder();
        Document document = docbuilder.newDocument();
        Element root = document.createElement("Bookmark");
        document.appendChild(root);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer transformer = tfactory.newTransformer();
        File outfile = new File(path);
        transformer.transform(new DOMSource(document), new StreamResult(outfile));
        return outfile;
    }
}

