
#include "defextern.h"

#ifndef STRICT
    #define STRICT
#endif
#include <windows.h>
#include "mes.h"
#include "mode.h"
#include "edit.h"
#include "initial.h"
#include "paintflag.h"
#include "myfilemv.h"

void DirEditSw()
{
	if( DirEditMode == _HIDE ) DirEditMode =_SHOW;
	else DirEditMode =_HIDE;
}
void buttonSw()
{
	if( ButtonMode == _HIDE ) ButtonMode =_SHOW;
	else ButtonMode =_HIDE;
}

void MemoOff(HWND hEdit)
{
	if( MemoMode == _ON ) 
	{
		saveMemo(hEdit);
	}
	MemoMode = _OFF;
}
void MemoOff()
{
	MemoOff(getMainEdit());
}

void MemoSw(HWND hEdit)
{
	static int lastmode;
	if( MemoMode == _ON ) 
	{
		saveMemo(hEdit);
		MemoMode = _OFF;
		mode = lastmode;
	}
	else 
	{
		loadMemo(hEdit);
		MemoMode = _ON;
		lastmode = mode;
		mode=W_MODE_EDITONLY;
	}
}

void initmode()
{
	mode =W_MODE_INIT;
	ButtonMode =_SHOW;
	DirEditMode =_SHOW;
	MemoMode = _OFF;
}

void setmode(int i)
{
	if(i>=W_MODE_MIN && i<=W_MODE_MAX ) mode=i;
}

void widemode()
{
	MemoOff();
	//mode =W_MODE_LIST;
	ButtonMode =_HIDE;
	showmenu =FALSE;
}

void editmode()
{
	MemoOff();
	mode=W_MODE_LISTnEDIT;
}
void editonlymode()
{
	MemoOff();
	mode=W_MODE_EDITONLY;
}

void listmode()
{
	MemoOff();
	mode=W_MODE_LIST;
}

void nextwinmode(int plus)
{
	MemoOff();
	mode +=plus;
	if(mode >W_MODE_MAX) mode =W_MODE_MIN;
	if(mode <W_MODE_MIN) mode =W_MODE_MAX;
}


void resetshowpic()
{
	picshowflg =FALSE;
	CurrentPicshow =FALSE;
	bmpflg =FALSE;
	isPicflg =FALSE;
}

void memomode(HWND hEdit)
{
	MemoSw(hEdit);
}