
#include "defextern.h"


#ifndef STRICT
    #define STRICT
#endif
#include <windows.h>
#include "main.h"
#include "dir.h"
#include "tabs.h"
#include "initial.h"
#include "status.h"
#include "mousegesture.h"
#include "paintflag.h"
#include "listview.h"
#include "myfilemv.h"
#include "winpaint.h"
#include "mainmsg.h"
#include "resource.h"

extern HBRUSH hbrush;
int calckaiten(char *longv, char *recentv);
BOOL calcIsCircle(POINTS a1, POINTS a2, POINTS a3, POINTS a4 );


POINTS stPoint,enPoint,sa,crPoint,lastPoint;
POINTS logpoint[LogPosMax];
int mpos=0; 
int lmpos=0; // }`ĈƂ͈{ƂɃZbg


int mvSens =20;
int saMin =1;
int sensMin =1;
int kaiten=0;


POINTS Sa(POINTS a, POINTS b)
{
	static POINTS c;
	c.x =a.x -b.x;
	c.y =a.y -b.y;
	return c;
}

int Kyori2(POINTS a, POINTS b)
{
	return max(abs(Sa(a,b).x),abs(Sa(a,b).y));
}


int mousecommand::calccloss()
{
	int findstart =2;
	int len=3;
	for (int i=0;i<mpos-len;i++)
	{
		for (int j=i+len;j<mpos-len;j++) if(calcIsCircle(logpoint[i],logpoint[j],logpoint[i+len],logpoint[j+len])) 
		{
			clossnum++;
			j=mpos;
			i+=findstart;
		}
	}
	return clossnum;
}


void mousecommand::changeVector()
{
	last[0]=0;
}


BOOL mousecommand::add(char *str)
{ 
	BOOL ans=FALSE;
	if(strlen(mousecom)<mousecommax-4 && strcmp(str,last)!=0) 
	{
		ans=TRUE;
		if(len==0) strcpy(mousecom,"");
		strcat(mousecom,str);
		len =strlen(mousecom);
	}
	strcpy(last,str);
	return ans;
};

BOOL mousecommand::addforce(char *str)
{ 
	BOOL ans=FALSE;
	if( strlen(mousecom)<mousecommax-4 ) 
	{
		ans=TRUE;
		strcat(mousecom,str);
	}
	strcpy(last,str);
	return ans;
};

mousecommand mc;


void DULR(char *mes, int x, int y, int saMin)
{
	int absx=abs(x);
	int absy=abs(y);
	if( absx >absy*3 )
	{
		if(x >saMin ) strcat(mes,"R"); //right
		if(x <-saMin) strcat(mes,"L"); //left
		return;
	}
	if( absy >absx*3 )
	{
		if(y >saMin) strcat(mes,"D"); //down
		if(y <-saMin) strcat(mes,"U"); //up
	}
}

void DULRmh(char *mes, int x, int y, int saMin)
{
	int absx=abs(x);
	int absy=abs(y);
	BOOL xbig =(absx>6 && absx>absy/2);
	BOOL ybig =(absy>6 && absy>absx/2);
	BOOL xsmall =(absx<3 || absx<absy/2);
	BOOL ysmall =(absy<3 || absy<absx/2);
	BOOL xybig =(xbig && ybig);
	BOOL xysame =(abs(absx-absy)<absx/2);
	if(x >saMin && xbig) 
	{
		if(y >saMin && xybig && xysame) strcat(mes,"m");
		else if(y <-saMin && xybig && xysame) strcat(mes,"M");
		else if(ysmall) strcat(mes,"R");
	}
	else if(x <-saMin && xbig) 
	{
		if(y >saMin && ybig && xysame) strcat(mes,"h");
		else if(y <-saMin && ybig && xysame) strcat(mes,"H");
		else if(ysmall) strcat(mes,"L"); //left
	}
	else if( xsmall && ybig)
	{
		if(y >saMin) strcat(mes,"D"); //down
		if(y <-saMin) strcat(mes,"U"); //up
	}
}

char * getMGchar(int x, int y, char *mes, char *mesmin)
{
	strcpy(mes,"");
	strcpy(mesmin,"");
	if(!nanameON) 
	{
		DULR(mes,x,y,saMin);
		DULR(mesmin,x,y,sensMin);
	}
	else
	{
		DULRmh(mes,x,y,saMin);
		DULRmh(mesmin,x,y,sensMin);
	}
	return mes;
}


int calckaiten(char *longv, char *recentv)
{
	char tmp[3];
	tmp[0]=longv[0];
	tmp[1]=recentv[0];
	tmp[2]=0;
	if(strstr("UHLhD",tmp)!=NULL) return 1;
	if(strstr("UMRmD",tmp)!=NULL) return -1;
	if(strstr("DmRMU",tmp)!=NULL) return 2;
	if(strstr("DhLHU",tmp)!=NULL) return -2;
	return 0;
}

BOOL circlecheck(char *str)
{
	char ci[]="UMRmDhLHUMRmDhLHU";
	char *p=ci;
	char *now;
	BOOL ret=TRUE;
	now=strchr(ci,str[0]);
	if(now!=NULL) now[9]=0;
	for(int i=1;i<strlen(str);i++)
	{
		if(now!=NULL) {
			now++;
		}
		else break;
		now=strchr(now,str[i]);
		if(now==NULL) 
		{
			ret=FALSE;
			break;
		}
	}
	if(ret) 
		return ret;
	
	int len=strlen(str);
	now=strchr(ci,str[len-1]);
	if(now!=NULL) now[9]=0;
	for(i=len-2;i>=0;i--)
	{
		if(now!=NULL) {
			now++;
		}
		else break;
		now=strchr(now,str[i]);
		if(now==NULL) 
		{
			ret=FALSE;
			break;
		}
	}
	return ret;
}

BOOL calcIsCircle(POINTS a1, POINTS a2, POINTS a3, POINTS a4 )
{
	static char mes1[3];
	static char mes2[3];
	char ans[6]="";
	POINTS sa[4];
	sa[0]=Sa(a1,a2);
	sa[1]=Sa(a2,a3);
	sa[2]=Sa(a3,a4);
	sa[3]=Sa(a4,a1);
	strcat(ans , getMGchar(sa[0].x, sa[0].y, mes1, mes2 ));
	strcat(ans , getMGchar(sa[1].x, sa[1].y, mes1, mes2 ));
	strcat(ans , getMGchar(sa[2].x, sa[2].y, mes1, mes2 ));
	strcat(ans , getMGchar(sa[3].x, sa[3].y, mes1, mes2 ));
	BOOL ret= (strlen(ans)>3 && circlecheck(ans));
	
	if(ret)
	{
		//Mes(ans);
	}
	return ret;
}


char * mouseLog(POINTS cr, POINTS la)
{
	setstatusMousepos(mpos, cr.x-stPoint.x, cr.y-stPoint.y);
	static char mes[3];
	wsprintf(mes,"");
	char mesmin[3]="";
	char mesLong[3]="";
	char mesminLong[3]="";
	POINTS saLong,saRecent;
	if (mpos>LogPosMax-1) return mes;
	logpoint[mpos]=la; //f[^
	int now =mpos;
	int lago =mpos-10;
	int ago =mpos-4;
	mpos++;
	lmpos++;
	if(mpos<11) return mes;
	saLong = Sa(logpoint[now],logpoint[lago]);
	saRecent = Sa(logpoint[now],logpoint[ago]);
	if(abs(saLong.x)<5 && abs(saLong.y)<5 ) return mes;

	static char lastmes[3]="";
	getMGchar(saLong.x, saLong.y, mesLong, mesminLong );
	getMGchar(saRecent.x, saRecent.y, mes, mesmin );
	if(strlen(mes)>0 && strlen(mesLong)>0 )
	{
		logwrite(mes,"");
		kaiten=calckaiten(mesLong,mes);
		if(strcmp(mes,lastmes)==0 && strcmp(mesLong,mes)==0 ) 
		{
			if(mc.add(mes)) setstatusonly(mc.getStatusStr());
		}
		else 
		{
			//mc.changeVector();
		}
		strcpy(lastmes,mes);
	}
	else if(strlen(mesmin)>0)
	{
		//if(strcmp(mesmin,lastmes)!=0) mc.changeVector();
	}
	return mes;
}

#define LINE(x0,y0,x1,y1) \
	MoveToEx(hdc,x0,y0,NULL);\
	LineTo(hdc,x1,y1);

#define LINE(a,b) \
	MoveToEx(hdc,a.x,a.y,NULL);\
	LineTo(hdc,b.x,b.y);

#define hosi 10
#define circle(a) \
	{MoveToEx(hdc,a.x-hosi,a.y,NULL);\
	LineTo(hdc,a.x,a.y-hosi);\
	LineTo(hdc,a.x+hosi,a.y);\
	LineTo(hdc,a.x,a.y+hosi);\
	LineTo(hdc,a.x-hosi,a.y);}

#define batu(a) \
	{MoveToEx(hdc,a.x-hosi,a.y-hosi,NULL);\
	LineTo(hdc,a.x+hosi,a.y+hosi);\
	MoveToEx(hdc,a.x-hosi,a.y+hosi,NULL);\
	LineTo(hdc,a.x+hosi,a.y-hosi);}

#define hos(a,b) \
	{MoveToEx(hdc,a.x,a.y-3*b,NULL);\
	LineTo(hdc,a.x+2*b,a.y+3*b);\
	LineTo(hdc,a.x-3*b,a.y-1*b);\
	LineTo(hdc,a.x+3*b,a.y-1*b);\
	LineTo(hdc,a.x-2*b,a.y+3*b);\
	LineTo(hdc,a.x,a.y-3*b);}

#define stMark(a,b) hos(a,b)

#define seize IDC_IBEAM
COLORREF mousepenC_P =RGB(0x10,0x10,0x10);
COLORREF mousepenC_L =RGB(0x3f,0x71,0xa0);//
COLORREF mousepenC_R =RGB(0x5f,0x71,0xd0);//
COLORREF mousepenC_D =RGB(0x61,0xcc,0xab);//
COLORREF mousepenC_U =RGB(0x91,0xcc,0xdb);//
COLORREF mousepenC_H =RGB(0x92,0xff,0x22);
COLORREF mousepenC_h =RGB(0x32,0xf9,0xa2);
COLORREF mousepenC_m =RGB(0xb2,0xff,0x42);
COLORREF mousepenC_M =RGB(0x52,0xfc,0x72);
COLORREF mousepenC_kRU =RGB(0x92,0x69,0x92);
COLORREF mousepenC_kRD =RGB(0xf2,0x69,0x62);
COLORREF mousepenC_kLU =RGB(0x92,0xa9,0x32);
COLORREF mousepenC_kLD =RGB(0xf2,0xa9,0x02);
COLORREF mousepenC_RBUp =RGB(0x52,0xa9,0x72);
COLORREF mousepenC =RGB(200,200,160);
#define mousepenWn 1
#define mousepenWok 2


// ^uAXgAIꂽقO

void selectSet( dirw &dir, HWND tab )
{
	resettitle( dir.cd() ,dir.getLR() );
	SetCurSel( tab, dir.getTabpos());
}

LRESULT CALLBACK ListProc( dirw &dir, WNDPROC oldproc, HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	RECT rect;
	PAINTSTRUCT ps;
	HDC hdc;
	static BOOL RBDown =FALSE;
	static BOOL mouseMalti =FALSE;
	static HPEN hPen0 =CreatePen(PS_SOLID, mousepenWn, mousepenC);
	static HPEN hPenRBUp =CreatePen(PS_SOLID, mousepenWn, mousepenC_RBUp);
	static HPEN hPenL =CreatePen(PS_SOLID, mousepenWok, mousepenC_L);
	static HPEN hPenR =CreatePen(PS_SOLID, mousepenWok, mousepenC_R);
	static HPEN hPenU =CreatePen(PS_SOLID, mousepenWok, mousepenC_U);
	static HPEN hPenD =CreatePen(PS_SOLID, mousepenWok, mousepenC_D);
	static HPEN hPenH =CreatePen(PS_SOLID, mousepenWok, mousepenC_H);
	static HPEN hPenh =CreatePen(PS_SOLID, mousepenWok, mousepenC_h);
	static HPEN hPenm =CreatePen(PS_SOLID, mousepenWok, mousepenC_m);
	static HPEN hPenM =CreatePen(PS_SOLID, mousepenWok, mousepenC_M);
	static HPEN hPenkLU =CreatePen(PS_SOLID, mousepenWok, mousepenC_kLU);
	static HPEN hPenkRU =CreatePen(PS_SOLID, mousepenWok, mousepenC_kRU);
	static HPEN hPenkLD =CreatePen(PS_SOLID, mousepenWok, mousepenC_kLD);
	static HPEN hPenkRD =CreatePen(PS_SOLID, mousepenWok, mousepenC_kRD);
	static int r,g,b;
	static BOOL csr=FALSE;
	static BOOL mgRF=FALSE;
	static BOOL mgF=FALSE;
	static BOOL mgLF=FALSE;
	char *p;
	//if(csr) SetCursor(LoadCursor(NULL, seize)); 
	
	switch(msg)
	{
	case WM_KILLFOCUS :
		resettxt();
		break;
	case WM_SETFOCUS :
		selectSet( dir, hTab );
		break;
	case WM_LBUTTONUP :
		mgLF=FALSE;
		//SetCursor(LoadCursor(NULL, IDC_ARROW)); 
		csr = FALSE; 
		break;
	case WM_LBUTTONDOWN :
		mouseMalti = FALSE;// reset
		mgLF=TRUE;
		//SetCursor(LoadCursor(NULL, IDC_IBEAM)); 
		csr = TRUE; 
		break;
	case WM_RBUTTONDOWN :
		//mouseMalti =FALSE;
		RBDown =TRUE;
		mgRF =TRUE;
		mgF =TRUE;
		lmpos=0;
		if(!mouseMalti) 
		{
			mc.reset();
			mpos=0;
		}
		logwrite("start","mg");
		lastPoint =MAKEPOINTS(lp);
		stPoint =lastPoint;
		if( mousegON ==FALSE ) SendMessage(hWnd, WM_RBUTTONUP, wp, lp);
		else SetCapture(hWnd);
		return 0;
	case WM_RBUTTONUP :
		RBDown =FALSE;
		enPoint =MAKEPOINTS(lp);
		sa.x =enPoint.x-stPoint.x;
		sa.y =enPoint.y-stPoint.y;
		// ۂŃ}`C[hJnI
		if(lmpos>1 && lmpos<30 && mgRF && abs(sa.x)+abs(sa.y)<20 )
		{
			if( mouseMalti ==FALSE )
			{
				mouseMalti=TRUE; 
				lmpos=0;
				mpos=0;
				WinFlash(hmainwnd);
				return 0;
			}
			if( mouseMalti )
			{
				mouseMalti=FALSE; 
			}
		}
		lmpos=0;
		if( mouseMalti ) 
		{
			mc.addforce("X");
			return 0;
		}

		//mpos=0;
		if(mgRF) mgF=FALSE;
		if( mousegON)
		{
			if( mgRF) 
			{
				ReleaseCapture();
				logwrite("end","mg");
				logwrite("mg",mc.getStr());
				mgRF =FALSE;
				if(mc.getStrlen()==0) break;
				if(mouseGTransF && mc.getStrlen()>0)
				{
					WORD msg=mgTrans(mc.getStr());
					if(msg>40000 && msg<60000) 
					{
						setstatus(mc.getStatusStr());
						mainMsg(msg);
						return 0;
					}
				}
				if(strcmp(mc.getStr(),"R")==0)
				{
					mainMsg(IDM_HIS_FORWARD);
					return 0;
				}
				if(strcmp(mc.getStr(),"L")==0)
				{
					mainMsg(IDM_HIS_BACKWARD);
					return 0;
				}
				if(strcmp(mc.getStr(),"U")==0)
				{
					mainMsg(IDM_UPDIRLOCAL);
					return 0;
				}
				if(strcmp(mc.getStr(),"UD")==0)
				{
					mainMsg(IDM_EDIT);
					return 0;
				}
				if(strcmp(mc.getStr(),"DL")==0)
				{
					mainMsg(IDM_ENTER);
					return 0;
				}
				setstatusMousepos(mpos,mc.getStrlen(),mc.calccloss());
				if(abs(sa.x)>0 && abs(sa.y)>0) return 0;
			}
		}
		mgRF =FALSE;
		break;
	case WM_MOUSEMOVE :
		crPoint =MAKEPOINTS(lp);
		if(mgRF)
		{
			if(RBDown) p =mouseLog(crPoint, lastPoint);
			HDC hdc =GetDC( hWnd);//createpen
			if(!RBDown) 
			{
				SelectObject( hdc, hPenRBUp ) ;
			}
			else 
			{
				if(kaiten==2) SelectObject( hdc, hPenkLU ) ;
				else if(kaiten==1) SelectObject( hdc, hPenkLD ) ;
				else if(kaiten==-2) SelectObject( hdc, hPenkRU ) ;
				else if(kaiten==-1) SelectObject( hdc, hPenkRD ) ;
				else if(strlen(p)==0) SelectObject( hdc, hPen0 ) ;
				else if (strstr("D",p)!=NULL) SelectObject( hdc, hPenD ) ;
				else if (strstr("U",p)!=NULL) SelectObject( hdc, hPenU ) ;
				else if(strstr("R",p)!=NULL) SelectObject( hdc, hPenR ) ;
				else if(strstr("L",p)!=NULL) SelectObject( hdc, hPenL ) ;
				else if(strstr("H",p)!=NULL) SelectObject( hdc, hPenH ) ;
				else if(strstr("M",p)!=NULL) SelectObject( hdc, hPenM ) ;
				else if(strstr("m",p)!=NULL) SelectObject( hdc, hPenm ) ;
				else if(strstr("h",p)!=NULL) SelectObject( hdc, hPenh ) ;
				if(mpos<2 && mgRF) stMark(stPoint,2);
				LINE( lastPoint, crPoint) ;
				SetPixel(hdc, lastPoint.x, lastPoint.y, mousepenC_P);
				stMark(crPoint,1);
			}
			ReleaseDC( hWnd, hdc);
		}
		lastPoint =crPoint;
		if(mousemv) SetFocus(hWnd);
		return 0;
	case WM_ERASEBKGND :
		return 0;
	case WM_PAINT :
		GetClientRect (hWnd, &rect) ;
		hdc =BeginPaint(hWnd, &ps);
			SetBkMode(hdc, OPAQUE);
		SelectObject( hdc, hbrush ) ;
		if(paintf) Rectangle(hdc,rect.left,rect.top,rect.right,rect.bottom);
		EndPaint(hWnd,&ps);
		InvalidateRect(hWnd,&rect,FALSE);
		break;
	case WM_DESTROY :
		DeleteObject(hPen0);
		DeleteObject(hPenh);
		DeleteObject(hPenH);
		DeleteObject(hPenM);
		DeleteObject(hPenm);
		DeleteObject(hPenU);
		DeleteObject(hPenD);
		DeleteObject(hPenL);
		DeleteObject(hPenR);
		DeleteObject(hPenkLU);
		DeleteObject(hPenkRD);
		DeleteObject(hPenkLD);
		DeleteObject(hPenkRU);
		break;
	default:
		;
	}
	return CallWindowProc( oldproc, hWnd, msg, wp, lp);
}