#include "defextern.h"

#ifndef STRICT
    #define STRICT
#endif
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <windows.h>
#include "edit.h"
#include "mes.h"
#include "initial.h"
#include "file.h"
#include "status.h"
#include "mode.h"

#define MAX_EDIT 1024*30
#define editsize MAX_EDIT
char buff[editsize];
char backupbuff[editsize];
char editfile[MAX_PATH];

struct buffers
{
	BOOL first;
	char buff[editsize];
	char backupbuff[editsize];
	char updatebuff[editsize];
	buffers(){
		first =TRUE;
		reset(buff);
		reset(backupbuff);
		reset(updatebuff);
	}
	void reset(char *buff) {memset(buff,0,editsize);}
	BOOL update(ofstream &klog) { 
		
		BOOL ans = strcmp(buff,backupbuff)==0;
		if(!ans && getnew()>0) 
		{
			if(!first) klog<<updatebuff;
			wsprintf(backupbuff,"%s",buff);
			first =FALSE;
		}
		//Mes(buff);
		return ans; 
	}
	int getnew() {
		char *p =buff;
		int i;
		for(i=0;i<strlen(buff);i++){
			if(*p == backupbuff[i]) p++;
			else break;
		}
		reset(updatebuff);
		if(i<strlen(buff)-1){
			strcpy(updatebuff,p);
			for(int j=0;j<strlen(updatebuff);j++){
				if(*p != backupbuff[i]) p++;
				else if(strcmp(p,(char*)(&(backupbuff[i])))==0){
					updatebuff[j]=0;
					break;
				}
			}
		}
		//Mes(updatebuff);
		return strlen(updatebuff);
	}
};

buffers klogbuffer;
 

//㏑ Ă悢t@C`FbN

BOOL checkoverwriteOK(char *file)
{
	setstatusonly(1,"-");
	if(checkExt(file,"exe")) return FALSE;
	if(checkExt(file,"EXE")) return FALSE;
	setstatusonly(1,"+");
	return TRUE;
}

//㏑ Ă悢t@C`FbN

void overwriteNO()
{
	setstatusonly(1,"big");
}

void cnvtoa(char *buf, int delim,long len,long denum)
{
	strcpy(backupbuff,buf);
	char *pfrom,*pto;
	pfrom =backupbuff;
	pto =buf;
	long count=0;

	for(long i=0; i+count<len; i++,pfrom++,pto++)
	{
		if(*pfrom!=delim) *pto=*pfrom;
		else {
			*pto=13;
			pto++;
			*pto=10;
			count++;
		}
	}
}


char *cnvbuff(char *buf, long len)
{
	int a=0;
	int d=0;
	int da=0;
	for(int i=0; i<1000; i++)
	{
		if(buf[i]==13){
			if( buf[i+1]==10) da++;
			else d++;
		}
		else if(buf[i]==10) a++;
	}
	if(da==1 && a+d>0)
	{
		if(a>3){
			cnvtoa(buf,10,len,a);
		}
		else if(d>3){
			cnvtoa(buf,13,len,d);
		}
	}
	return buf;
}

//edit window \
//t@CݒAe\AeobNAbvobt@ɃRs[iԖʂj
//utf-8ifirefox bookmark.htmȂǁjIƂȂԂH

void setfile(HWND hEdit,char *file,char *dir)
{
	SetWindowText(hEdit,"loading..");
	SetCurrentDirectory(dir);
	_fullpath(editfile,file,MAX_PATH);
	editflag=FALSE;
	memset(buff,0,sizeof(buff));
	memset(backupbuff,0,sizeof(backupbuff));
	ifstream in(editfile,ios::binary | ios::nocreate);
	sprintf(buff,"$.%s\r\n",file);
	int headlen=strlen(buff);
	long rsize =editsize-headlen-2;
	if(in) {
		in.read(buff+headlen,rsize);
		cnvbuff(buff,rsize);
		strcpy(backupbuff,buff);
		SetWindowText(hEdit,buff);
		checkoverwriteOK(editfile);
	}
	if(getfilesize(file)<editsize-1000)
	{
		editflag=TRUE;
	}
	else
	{
		editflag=FALSE;
		overwriteNO();
	}
		
}


char* getCurrentEditWinStr(HWND hEdit)
{
	memset(buff,0,sizeof(buff));
	GetWindowText(hEdit,buff,editsize-2);
	return buff;
}

//㏑
//obNAbvobt@ƔrAXVĂꍇ̂݁B

void overwrite(HWND hEdit)
{
	if(editflag)
	{
		memset(buff,0,sizeof(buff));
		GetWindowText(hEdit,buff,editsize-2);
		if(strcmp(backupbuff,buff)!=0 && checkoverwriteOK(editfile)) 
		{
			ofstream ou(editfile,ios::binary);
			ou.write(buff,strlen(buff));
		}
	}
	else
	{
		MessageBox(NULL, "TCY傫㏑ot@Cł͂܂", "Error", MB_OK);
	}
}

//㏑At@C؂ւOɌĂяoAꂢ͌Ă΂Ȃ
void autooverwrite(HWND hEdit)
{
	if(editflag)
	{
		overwrite(hEdit);
	}
}


BOOL geteditflag()
{
	return editflag;
}

void seteditflag(BOOL f)
{
	editflag=f;
}

int readline(char *to,char *from,int len=0)
{
	int i;
	if(len==0) len=strlen(from);
	strncpy(to,from,len);
	for (i=0; i<strlen(to);i++)
	{
		if(to[i]==0x0d ||to[i]==0x0a){
			to[i]=0;
			break;
		}
	}
	return i;
}

void cnvfname(char *to,char *from=NULL)
{
	if(from==NULL) from=to;
	char buff[MAX_PATH];
	strcpy(buff,from);
	char bad[]="\\ /:*?\"<>|";
	for(int i=0;i<strlen(from);i++)
	{
		if(strchr(bad,buff[i])!=NULL) buff[i]='_';
	}
	strcpy(to,buff);
//	Mes(buff);
}

int gettmpname(char *tmpfile, char *buff ,char *top=NULL)
{
	int i=0;
	int hlen;
	if(top!=NULL) {
		hlen=strlen(top);
		if(strncmp(buff,top,hlen)==0) {
			i=readline(tmpfile,buff+hlen,MAX_PATH-6);
			if( strchr(tmpfile,'.') ==NULL ) strcat(tmpfile,".txt");
			return i;
		}
	}
	else {
		i=readline(tmpfile,buff+2,MAX_PATH-2);
		cnvfname(tmpfile);
		if( strchr(tmpfile,'.') ==NULL ) strcat(tmpfile,".txt");
	}
	return i;
}


// 擪sŖOw肵ĂΕۑ
// $.filename  => current folder
// $>filename  => memo folder

void saveTempo(HWND hEdit)
{
	char mfile[MAX_PATH];
	char tmpfile[MAX_PATH];
	
	memset(buff,0,sizeof(buff));
	memset(tmpfile,0,sizeof(tmpfile));
	GetWindowText(hEdit,buff,editsize-2);
	int pos = gettmpname( tmpfile, buff, "$>" );
	if( pos!=0 ) {
		GetFullName(mfile, tmpfile, memopath, MAX_PATH);
	}
	else {
		pos = gettmpname( tmpfile, buff, "$." );
		if( pos!=0 ) {
			strcpy(mfile, tmpfile);
		}
		else {
			wsprintf(mfile,"%s.txt", gettimestr());
		//	Mes(mfile);
			ofstream ou(mfile,ios::binary);
			if(ou) {
				ou.write(buff,strlen(buff));
				//Mes(mfile);
			}
			return;
		}
	}
	ofstream ou(mfile,ios::binary);
	if(ou && strlen(buff)-pos-4>0) {
		ou.write(buff+pos+4,strlen(buff)-pos-4);
	}
	else Mes("can't save");
}

void saveMemo(HWND hEdit)
{
	//Mes("save memo");
	char mfile[MAX_PATH];
	char buff[editsize];
	GetFullName(mfile, memofile, memopath, MAX_PATH);
	
	memset(buff,0,sizeof(buff));
	if( MemoMode ==_OFF || hEdit == NULL ) return;
	GetWindowText(hEdit,buff,editsize-2); 
	if(strcmp(backupbuff,buff)!=0 ) 
	{
		ofstream ou(mfile,ios::binary);
		if(ou) {
			ou.write(buff,strlen(buff));
			SetWindowText(hEdit,"");
		}
		else Mes("can't save");
	}
}

int renameMemo()
{
	char newfile[MAX_PATH];
    char ToFile[MAX_PATH], FromFile[MAX_PATH];

	makenewfilenameEx(memofile,newfile);
	//wsprintf(memofile,"%s",newfile);
	GetFullName(ToFile, newfile, memopath, MAX_PATH);
	GetFullName(FromFile, memofile, memopath, MAX_PATH);
	return rename( FromFile, ToFile );
}

int changeMemo(HWND Edit)
{
	if (Edit!=NULL) saveMemo(Edit);
	int res=(renameMemo());
	if(res) SetWindowText(Edit,"");
	return res;
}

void askmemoname(char *path)
{
	//
}

void loadMemo(HWND hEdit)
{
	if(strlen(memopath)==0)
	{
		askmemoname(memopath);
	}
	if(strlen(memopath)==0)
	{
		strcpy(memopath,getCdir());
	}
	
	char mfile[MAX_PATH];
	GetFullName(mfile, memofile, memopath, MAX_PATH);
	
	memset(buff,0,sizeof(buff));
	ifstream in(mfile,ios::binary | ios::nocreate);
	if(in) in.read(buff,editsize-2);
	cnvbuff(buff,editsize-2);
	strcpy(backupbuff,buff);
	SetWindowText(hEdit,buff);
	//Mes(mfile);
}

void keylog( HWND hEdit, WORD key)
{
	if(MemoMode == _OFF) return;
	GetStream("key.log.txt", memopath, klog, ios::ate);
// Mes(klog? 1:-1);
	GetWindowText(hEdit,klogbuffer.buff,editsize-2); 
	klogbuffer.update(klog);
	klog.close();
}