#include "defextern.h"

#ifndef STRICT
    #define STRICT
#endif
#include <stdio.h>
#include <windows.h>
#include "mes.h"

namespace lua
{
	char buffer[1000];
}
using lua::buffer;

void printError(const char *name, int err)
{
	LPVOID pbuf;
	FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER |
		FORMAT_MESSAGE_FROM_SYSTEM |
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		err,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		(char*)&pbuf,
		0,
		NULL
	);
	sprintf(buffer,"%s: %d:%s\n", name, err, pbuf);
	Mes(buffer);
	LocalFree(pbuf);
}

typedef ( __stdcall *luac)(char* ,char*,char*);

void luacall(char *val,char *str,char *luafile)
{
	luac tes;
	HINSTANCE hLib=NULL;
	hLib = LoadLibrary("moflua.dll");
	if(hLib!=NULL)
	{
		tes  = (luac) GetProcAddress(hLib, "_tes@12");
		if(tes==NULL) printError("GetProcAddress", GetLastError());
		else 
		{
			if(tes(val,str,luafile)==-1)
			{
				wsprintf(buffer,"%s/%s܂",str,luafile);
				Mes(buffer);
			}
		}
	}
	else
	{
		printError("LoadLibrary", GetLastError());
	}
}