#ifndef __SEARCH_H__
#define __SEARCH_H__

#include "filter_conditions_dialog.h"
#include "state.h"
#include <set>

class CWindowStateManager;
class CSearchDialogFileList;
class CQueueView;
class CFilelistStatusBar;
class CSearchDialog : protected CFilterConditionsDialog, public CStateEventHandler
{
	friend class CSearchDialogFileList;
public:
	CSearchDialog(wxWindow* parent, CState& state, CQueueView* pQueue);
	virtual ~CSearchDialog();

	bool Load();
	void Run();

protected:
	void ProcessDirectoryListing(std::shared_ptr<CDirectoryListing> const& listing);

	void SetCtrlState();

	void SaveConditions();
	void LoadConditions();

	wxWindow* m_parent;
	CSearchDialogFileList *m_results{};
	CQueueView* m_pQueue;

	virtual void OnStateChange(t_statechange_notifications notification, const wxString& data, const void* data2);

	CWindowStateManager* m_pWindowStateManager{};

	CFilter m_search_filter;

	bool m_searching{};

	CServerPath m_original_dir;
	CLocalPath m_local_target;

	void ProcessSelection(std::list<int> &selected_files, std::deque<CServerPath> &selected_dirs);

	DECLARE_EVENT_TABLE()
	void OnSearch(wxCommandEvent& event);
	void OnStop(wxCommandEvent& event);
	void OnContextMenu(wxContextMenuEvent& event);
	void OnDownload(wxCommandEvent&);
	void OnEdit(wxCommandEvent&);
	void OnDelete(wxCommandEvent&);
	void OnCharHook(wxKeyEvent& event);

	std::set<CServerPath> m_visited;

	CServerPath m_search_root;
};

#endif //__SEARCH_H__
