/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.model;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import jp.gr.java_conf.ktz.puzzle.fillo.util.StateEventUtility;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;

public class BoardModel
extends AbstractDecoratedModel {
    private Cell[] mCells;
    private int mWidth;
    private int mHeight;
    private Set mLastModified = new HashSet();

    public BoardModel() {
        this(NullModel.getInstance());
    }

    public BoardModel(Model model) {
        super(model);
    }

    protected void createBoardSelf(int n, int n2) {
        if (n == this.mWidth && n2 == this.mHeight) {
            return;
        }
        this.flushSelf();
        this.mWidth = n;
        this.mHeight = n2;
        this.mCells = new Cell[this.mWidth * this.mHeight];
        for (int i = 0; i < this.mHeight; ++i) {
            for (int j = 0; j < this.mWidth; ++j) {
                this.mCells[i * this.mWidth + j] = new Cell();
                this.mLastModified.add(new Point(j, i));
            }
        }
    }

    public int setProblem(ProblemInfo problemInfo) {
        if (this.mWidth != problemInfo.getWidth() || this.mHeight != problemInfo.getHeight()) {
            this.createBoard(problemInfo.getWidth(), problemInfo.getHeight());
        }
        if (!problemInfo.isMoreRead()) {
            return Integer.MIN_VALUE;
        }
        int n = 0;
        if (problemInfo.isDivideRead()) {
            n = problemInfo.getOffset();
        }
        for (int i = n; i < n + problemInfo.getReadOnce(); ++i) {
            State state = this.idsToState((String)problemInfo.getRecordAt(i));
            if (this.mCells[i].getState() == state) continue;
            this.mCells[i].setState(state);
            this.addModifiedSet(i);
        }
        return problemInfo.isDivideRead() ? problemInfo.getReadOnce() : Integer.MIN_VALUE;
    }

    protected void initProblemAtSelf(int n, int n2, Object object) {
        if (!this.contains(n, n2)) {
            throw new IllegalArgumentException("0 < x <= " + this.mWidth + ", 0 < y <= " + this.mHeight + " (inX : " + n + ", inY : " + n2 + ")");
        }
        if (null == object) {
            throw new IllegalArgumentException("Cannot pass null-value to inRecord");
        }
        State state = this.idsToState((String)object);
        Cell cell = this.getCellAt(n, n2);
        if (cell.getState() != state) {
            cell.setState(state);
            this.addModifiedSet(n, n2);
        }
        if (cell.isNumber()) {
            cell.setImmutable();
        }
    }

    private State idsToState(String string) {
        State state = StateManager.getInstance().createStateOf(string.trim());
        if (state == null) {
            throw new IllegalArgumentException("A specified ID '" + string.trim() + "' is ignore.");
        }
        return state;
    }

    private void addModifiedSet(int n) {
        int n2 = n % this.mWidth;
        int n3 = n / this.mWidth;
        this.addModifiedSet(n2, n3);
    }

    private void addModifiedSet(int n, int n2) {
        this.mLastModified.add(new Point(n, n2));
    }

    public boolean check() {
        return false;
    }

    public void reset() {
    }

    protected void resetAtSelf(int n, int n2) {
    }

    public Dimension getSize() {
        return new Dimension(this.mWidth, this.mHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public State getCurStateAt(int n, int n2) {
        return this.getCellAt(n, n2).getState();
    }

    public void nextStateAt(int n, int n2) {
        throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method nextStateAt.");
    }

    protected void nextStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
        if (!StateEventUtility.isNumberStateEventCode(stateEventCode)) {
            throw new IllegalArgumentException("inCode is not NumberStateEventCode");
        }
        Cell cell = this.getCellAt(n, n2);
        if (cell.isImmutable()) {
            return;
        }
        State state = StateManager.getInstance().getNextState(cell.getState(), stateEventCode);
        if (cell.getState() != state) {
            cell.setState(state);
            this.mLastModified.add(new Point(n, n2));
        }
    }

    public void prevStateAt(int n, int n2) {
        throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method prevStateAt.");
    }

    protected void prevStateAtSelf(int n, int n2, StateEventCode stateEventCode) {
        throw new UnsupportedOperationException();
    }

    protected synchronized Point[] lastModifiedSelf() {
        return this.mLastModified.toArray(new Point[this.mLastModified.size()]);
    }

    protected synchronized boolean isModifiedSelf() {
        return !this.mLastModified.isEmpty();
    }

    protected synchronized void flushSelf() {
        if (this.mLastModified.isEmpty()) {
            return;
        }
        this.mLastModified.clear();
    }

    public boolean isNumberAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            return false;
        }
        return this.getCellAt(n, n2).isNumber();
    }

    public boolean isSpaceAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            return false;
        }
        return this.getCellAt(n, n2).isSpace();
    }

    public boolean isTransitAt(int n, int n2, StateEventCode stateEventCode) {
        if (!this.contains(n, n2)) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isTransitAt(int n, int n2) {
        throw new UnsupportedOperationException("the method isTransitAt(int, int) is unsupported");
    }

    protected boolean isAcceptableEvent(StateEventCode stateEventCode) {
        return StateEventUtility.isNumberStateEventCode(stateEventCode);
    }

    public boolean contains(int n, int n2) {
        return n >= 0 && n < this.mWidth && n2 >= 0 && n2 < this.mHeight;
    }

    public State getCorrectStateAt(int n, int n2) {
        throw new UnsupportedOperationException("This model isnot supported getCorrectStateAt method.");
    }

    private Cell getCellAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            throw new IndexOutOfBoundsException("0 <= x < " + this.mWidth + ", 0 <= y < " + this.mHeight + " (inX : " + n + ", inY : " + n2 + ")");
        }
        return this.mCells[n2 * this.mWidth + n];
    }

    private static class Cell {
        private State mState = this.getDefaultState();
        private boolean mImmutable;

        Cell() {
        }

        State getState() {
            return this.mState;
        }

        void setState(State state) {
            this.mState = state;
        }

        private State getDefaultState() {
            return StateManager.getInstance().createDefaultState();
        }

        boolean isSpace() {
            return StateManager.getInstance().isSpaceState(this.mState);
        }

        boolean isNumber() {
            return StateManager.getInstance().isNumberState(this.mState);
        }

        void setImmutable() {
            this.mImmutable = true;
        }

        boolean isImmutable() {
            return this.mImmutable;
        }
    }
}

