/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ChangeHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.FilloChangeHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.FilloProblemLoader;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ProblemLoader;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.SelectionModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.FilloDefaultRendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.FilloRenderStrategy;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.FilloStateRendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.InputHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderStrategy;
import jp.gr.java_conf.ktz.puzzle.fillo.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.fillo.util.InputUtility;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.util.Command;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.BoardView;

public class FilloBoardView
extends Canvas
implements BoardView {
    private RenderStrategy mStrategy;
    private InputHandler mInputHandler;
    private ProblemLoader mProblemLoader;

    public void initialize() {
        SelectionModel selectionModel = new SelectionModel((Model)new BoardModel());
        selectionModel.createBoard(7, 7);
        this.mStrategy = new FilloRenderStrategy((Model)selectionModel);
        this.mStrategy.setSize(7, 7);
        this.mStrategy.setBackground(AppColors.BACK_COLOR);
        this.mStrategy.installDefaultRenderer(new FilloDefaultRendererFactory());
        this.mStrategy.installRenderer(new FilloStateRendererFactory());
        FilloInputHandler filloInputHandler = new FilloInputHandler((Model)selectionModel);
        this.addMouseListener(filloInputHandler);
        this.addKeyListener(filloInputHandler);
        this.mInputHandler = filloInputHandler;
        this.mProblemLoader = new FilloProblemLoader((Model)selectionModel);
        this.mProblemLoader.loadProblem(new ProblemInfo("untitled", 0, 4, 5, "4, s, 2, s, s, s, s, 2, s, s, s, s, s, 2, s, 4, 1, s, s, 3".split(",")));
        this.mInputHandler.resetActivePos(0, 0);
        this.setBackground(AppColors.BACK_COLOR);
        this.setSize(this.mStrategy.getBoardSize());
    }

    public void setParent(BoardView boardView) {
        throw new UnsupportedOperationException();
    }

    public boolean isModified() {
        throw new UnsupportedOperationException();
    }

    public Component getComponent() {
        return this;
    }

    public void setFocus(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean isFocused() {
        throw new UnsupportedOperationException();
    }

    public void processCommand(Command command) {
        throw new UnsupportedOperationException();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.mStrategy.render(), 0, 0, this);
    }

    private class FilloInputHandler
    implements InputHandler,
    MouseListener,
    KeyListener {
        ChangeHandler mHandler;

        FilloInputHandler(Model model) {
            this.mHandler = new FilloChangeHandler(model);
        }

        public void resetActivePos(int n, int n2) {
            this.mHandler.notifySelectionChanged(n, n2, false, false);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Cloneable cloneable;
            boolean bl = false;
            int n = mouseEvent.getClickCount();
            if (n == 1) {
                cloneable = FilloBoardView.this.mStrategy.calcPortToBoardPos(mouseEvent.getX(), mouseEvent.getY());
                bl = this.mHandler.notifySelectionChanged(cloneable.x, cloneable.y, false, false);
            } else if (n == 2) {
                System.out.println("mouse double clicked !!");
            }
            if (bl) {
                cloneable = FilloBoardView.this.mStrategy.getClipBounds();
                FilloBoardView.this.repaint(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            boolean bl = false;
            if (InputUtility.availableInputKey(c)) {
                bl = this.mHandler.notifyInputOccured(InputUtility.convertValueFor(c));
            }
            if (bl) {
                Rectangle rectangle = FilloBoardView.this.mStrategy.getClipBounds();
                FilloBoardView.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

