// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardSelectionTest.java
//	DATE:		2003.11.29
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.controller;

import java.awt.Point;

import junit.framework.TestSuite;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.SelectionState;

import jp.gr.java_conf.ktz.puzzle.fillo.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.SelectionModel;

import jp.gr.java_conf.ktz.puzzle.fillo.util.TestUtility;

import jp.gr.java_conf.ktz.puzzle.fillo.fsm.ActiveSelectionState;

public class BoardSelectionTest extends junit.framework.TestCase {
	public static junit.framework.Test suite() {
		TestSuite aSuite = new TestSuite("usecase name : select one cell");
		
		aSuite.addTest(new TestSuite(BoardSelectionTest.class));
		
		return aSuite;
	}
	
	private Model mModel;
	private FilloChangeHandler mHandler;
	
	protected void setUp() {
		mModel = new SelectionModel(new BoardModel());
		mModel.createBoard(6, 8);
		mHandler = new FilloChangeHandler(mModel);
		mHandler.notifySelectionChanged(0, 0, false, false);
		
		TestUtility.reflectScreen(mModel);
	}
	
	public void testSelectCellSelection() {
		// ՖʂύXĂȂƂ`FbN
		assertEquals(false, mModel.isModified());
		
		// ύXӏOӏł邱Ƃ`FbN
		assertEquals(0, mModel.lastModified().length);
		
		// ANeBu|WVƓZIǂ`FbN
		assertEquals(true, mHandler.isActivePos(new Point(0, 0)));
		
		// (0, 0)IԂł邱Ƃ`FbN
		assertEquals(ActiveSelectionState.class, mModel.getCurStateAt(0, 0).getClass());
		
		// (0, 1)I
		mHandler.notifySelectionChanged(0, 1, false, false);
		
		// ՖʂύXĂ邱Ƃ`FbN
		assertEquals(true, mModel.isModified());
		
		// ύXӏOӏł邱Ƃ`FbN
		assertEquals(2, mModel.lastModified().length);
		
		// (0, 0)󔒏Ԃł邱Ƃ`FbN
		assertEquals(SpaceState.class, mModel.getCurStateAt(0, 0).getClass());
		
		// (0, 1)IԂł邱Ƃ`FbN
		assertEquals(ActiveSelectionState.class, mModel.getCurStateAt(0, 1).getClass());
		
		// ANeBu|WV(0, 1)ł邩ǂ`FbN
		assertEquals(true, mHandler.isActivePos(new Point(0, 1)));
		
		// ύX𔽉f
		TestUtility.reflectScreen(mModel);
		
		// ՖʂύXĂȂƂ`FbN
		assertEquals(false, mModel.isModified());
		
		// ύXӏOӏł邱Ƃ`FbN
		assertEquals(0, mModel.lastModified().length);
	}
	
	public void testSameCellSelection() {
		// ANeBu|WVƓZI邩ǂ`FbN
		assertEquals(true, mHandler.isActivePos(new Point(0, 0)));
		
		// (0, 0)I
		mHandler.notifySelectionChanged(0, 0, false, false);
		
		// ՖʂύXĂȂƂ`FbN
		assertEquals(false, mModel.isModified());
		
		// ύXӏOӏł邱Ƃ`FbN
		assertEquals(0, mModel.lastModified().length);
	}
}