// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		ChangeEventFactory.java
//	DATE:		2003.11.29
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.controller;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.fillo.util.StateEventUtility;

/**
 *	e^CvɉChangeEvent쐬邽߂Factory MethodQ
 */
public class ChangeEventFactory {
	/**
	 *	Model̑IԂ̕ύXʒm邽߂̃Cxg쐬B
	 *
	 *	@param	inIsActivePos	ύXʒuANeBu|WVł邩ǂtO
	 *	
	 *	@return	쐬StateEventCode
	 */
	public static StateEventCode createSelectionEvent(final boolean inIsActivePos) {
		return new ChangeEvent(ChangeEvent.TYPE_SELECTION, inIsActivePos, "");
	}
	
	/**
	 *	Modelւ̓͂̔ʒm邽߂̃Cxg쐬B
	 *
	 *	@param	inVal	ύXʒuɓ͂l
	 *	
	 *	@return	쐬StateEventCode
	 */
	public static StateEventCode createNumberInputEvent(String inVal) {
//		return new ChangeEvent(ChangeEvent.TYPE_INPUT_NUM, false, inVal);
		return StateEventUtility.getNumberStateEventCode(inVal);

	}
}