// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		FilloChangeHandler.java
//	DATE:		2003.11.29
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.controller;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.DecoratedState;

import jp.gr.java_conf.ktz.puzzle.framework.constants.Direction;

import jp.gr.java_conf.ktz.puzzle.fillo.util.InputUtility;

/**
 *	Ֆʂ̕ύX𐧌䂷nh
 */
public class FilloChangeHandler implements ChangeHandler {
	private static final Direction[] DIRECTIONS = new Direction[] {
		Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, 
	};
	
	private Point mActivePos;
	
	private Model mModel;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inModel	ΏۂƂȂ郂f
	 */
	public FilloChangeHandler(Model inModel) {
		mModel = inModel;
		
		mActivePos = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
	}
	
	/**
	 *	Ֆʂ̑Ï悪ύXƂʒm
	 *
	 *	@param	inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@param	inRangeSelected	A͈͂IꂽǂtO
	 *	@param	inIsSuccessive	IsꂽǂtO
	 *
	 *	@return	ύXeꂽꍇAtrueԂB
	 */
	public boolean notifySelectionChanged(
			final int inX, final int inY, 
			final boolean inRangeSelected, final boolean inIsSuccessive)
	{
		Point aNewActive = new Point(inX, inY);
		
		if (aNewActive.equals(mActivePos)) return false;
		
		mActivePos = aNewActive;
		
		StateEventCode aEvent = ChangeEventFactory.createSelectionEvent(true);
		mModel.nextStateAt(inX, inY, aEvent);
		
		return (mModel.isModified() ? true : false);
	}
	
	boolean isActivePos(Point inPos) {
		return mActivePos.equals(inPos);
	}
	
	/**
	 *	Ֆʂ֓͂Ƃʒm
	 *
	 *	@param	inVal	͂
	 *
	 *	@return	ύXeꂽꍇAtrueԂB
	 */
	public boolean notifyInputOccured(String inVal) {
		if (isSameInput(mActivePos, inVal)) return false;
		if (! velifyInputRange(inVal)) return false;
		
		StateEventCode aEvent = ChangeEventFactory.createNumberInputEvent(inVal);
		mModel.nextStateAt(mActivePos.x, mActivePos.y, aEvent);
		
		return mModel.isModified();
	}
	
	boolean velifyInputRange(String inVal) {
		// ͂폜łꍇ͔͈͌sȂ
		if (InputUtility.isDeleteOccured(inVal)) return true;
		
		final int aInputNum = InputUtility.getInputValue(inVal);
		
		return velifyInputRangeSub(inVal, aInputNum, new Point(mActivePos), new java.util.HashSet());
	}
	
	private boolean velifyInputRangeSub(String inVal, final int inInputNum, Point inPos, java.util.Set inSeries) {
		inSeries.add(new Point(inPos));
		
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			Point aDiff = DIRECTIONS[i].getDifference();
			inPos.translate(aDiff.x, aDiff.y);
			
			if (mModel.isNumberAt(inPos.x, inPos.y) && ! inSeries.contains(inPos)) {
				if (isSameInput(inPos, inVal)) {
					// ɓ͒lȏ̃ZAĂꍇATł؂B
					if (inInputNum <= inSeries.size()) return false;
					if (! velifyInputRangeSub(inVal, inInputNum, inPos, inSeries)) return false;
				}
			}
			
			inPos.translate(-aDiff.x, -aDiff.y);
		}	
		
		if (inInputNum < inSeries.size()) throw new RuntimeException();
		return (inInputNum < inSeries.size() ? false : true);
	}
	
	State peelState(State inState) {
		if (inState instanceof DecoratedState) {
			return peelState(((DecoratedState)inState).getDecorated());
		}
		
		return inState;
	}
	
	boolean isSameInput(Point inPos, String inVal) {
		if (null == inVal) {
			throw new IllegalArgumentException("inVal is null");
		}
		
		// ANeBu|WVw肵ƈႤꍇA͈͌sȂ
		State aState = peelState(mModel.getCurStateAt(inPos.x, inPos.y));
		String aIDs = StateManager.getInstance().findIdentityOf(aState);
		
		return aIDs.equals(inVal);
	}
}