// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		FilloProblemLoader.java
//	DATE:		2003.12.4
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.controller;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;

public class FilloProblemLoader implements ProblemLoader {
	Model mModel;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inModel	ΏۂModel
	 */
	public FilloProblemLoader(Model inModel) {
		mModel = inModel;
	}
	
	/**
	 *	 w肳ꂽǂݍ
	 *
	 *	@param	inProblem	ǂݍޖ
	 */
	public void loadProblem(ProblemInfo inProblem) {
		final int aWidth = inProblem.getWidth();
		final int aHeight = inProblem.getHeight();
		
		if (aWidth != mModel.getWidth() || aHeight != mModel.getHeight()) {
			mModel.createBoard(aWidth, aHeight);
		}
		
		for (int y = 0, i = 0; y < aHeight; ++y) {
			for (int x = 0; x < aWidth; ++x, ++i) {
				mModel.initProblemAt(x, y, inProblem.getRecordAt(i));
			}
		}
	}
}