// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		NumberInputTest.java
//	DATE:		2003.12.2
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.controller;

import java.awt.Point;

import junit.framework.TestSuite;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;

import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.fillo.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.SelectionModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.EditableNumberStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.fillo.fsm.ActiveSelectionState;

import jp.gr.java_conf.ktz.puzzle.fillo.util.TestUtility;

public class NumberInputTest extends junit.framework.TestCase {
	public static TestSuite suite() {
		TestSuite aSuite = new TestSuite("usecase name : input number at one cell");
		
		aSuite.addTest(new TestSuite(NumberInputTest.class));
		
		return aSuite;
	}
	
	private Model mModel;
	private FilloChangeHandler mHandler;
	
	private String mExpected;
	
	protected void setUp() {
		// ԑJڃ}l[WB
		StateManager.initialize(new EditableNumberStateManagerImpl());
		
		// SelectionModelŃbvBoardModel쐬B
		mModel = new SelectionModel(new BoardModel());
		
		// TCYXwV̔Ֆʂ쐬B
		mModel.createBoard(9, 7);
		
		// FilloChangeHandler쐬
		mHandler = new FilloChangeHandler(mModel);
		
		// (0, 0)IԂɂB
		mHandler.notifySelectionChanged(0, 0, false, false);
		
		// Ֆʂ̕ύXZbgB
		TestUtility.reflectScreen(mModel);
	}
	
	private void setExpected(String inString) {
		mExpected = inString;
	}
	
	private void setReal(String inString) {
		assertEquals(mExpected, inString);
	}
	
	private String parseDecoratedState(State inState) {
		return TestUtility.parseDecoratedState(inState);
	}
	
	public void testInputNumAtUniSelection1() {
		// (0, 0)󔒂ł邱ƂmFB
		assertEquals(true, mModel.isSpaceAt(0, 0));
		
		// (0, 0)IԂł邱ƂmFB
		assertEquals(true, mHandler.isActivePos(new Point(0, 0)));

		setExpected("[ActiveSelectionState()][SpaceState()]");
		setReal(parseDecoratedState(mModel.getCurStateAt(0, 0)));
		
		// R̓͂Ół邱ƂmFB
		assertEquals(true, mHandler.velifyInputRange(String.valueOf(3)));
		
		// (0, 0)ɂR͂B
		assertEquals(true, mHandler.notifyInputOccured(String.valueOf(3)));
		
		// ՖʂύXĂ邱ƂmFB
		assertEquals(true, mModel.isModified());
		
		// ύXӏPӏł邱ƂmFB
		assertEquals(1, mModel.lastModified().length);
		
		// (0, 0)̏Ԃł邱ƂmFB
		assertEquals(true, mModel.isNumberAt(0, 0));
		
		setExpected("[ActiveSelectionState()][NumberState(3)]");
		setReal(parseDecoratedState(mModel.getCurStateAt(0, 0)));
	}
	
	public void testInputNumAtUniSelection2() {
		State aState = null;
		
		// (0, 0)ɂR͂B
		assertEquals(true, mHandler.notifyInputOccured(String.valueOf(3)));
		
		// Ֆʂ̕ύXZbgB
		TestUtility.reflectScreen(mModel);

		// (0, 0)Ԃł邱ƂmFB
		assertEquals(true, mModel.isNumberAt(0, 0));
				
		// (0, 0)IԂł邱ƂmFB
		assertEquals(true, mHandler.isActivePos(new Point(0, 0)));
		
		setExpected("[ActiveSelectionState()][NumberState(3)]");
		setReal(parseDecoratedState(mModel.getCurStateAt(0, 0)));
		
		assertEquals(false, mHandler.isSameInput(new Point(0, 0), String.valueOf(5)));
		
		// 5̓͂Ół邱ƂmFB
		assertEquals(true, mHandler.velifyInputRange(String.valueOf(5)));
		
		// (0, 0)5͂B
		assertEquals(true, mHandler.notifyInputOccured(String.valueOf(5)));
		
		// ՖʂύXĂ邱ƂmFB
		assertEquals(true, mModel.isModified());
		
		// ύXӏPӏł邱ƂmFB
		assertEquals(1, mModel.lastModified().length);
		
		setExpected("[ActiveSelectionState()][NumberState(5)]");
		setReal(parseDecoratedState(mModel.getCurStateAt(0, 0)));
	}
	
	public void testSameInputNumber() {
		// (0, 0)ɂS͂B
		assertEquals(true, mHandler.notifyInputOccured(String.valueOf(4)));
		
		// Ֆʂ̕ύXZbgB	
		TestUtility.reflectScreen(mModel);
		
		// (0, 0)Ԃł邱ƂmFB
		assertEquals(true, mModel.isNumberAt(0, 0));
		
		// (0, 0)IԂł邱ƂmFB
		assertEquals(true, mHandler.isActivePos(new Point(0, 0)));

		setExpected("[ActiveSelectionState()][NumberState(4)]");
		setReal(parseDecoratedState(mModel.getCurStateAt(0, 0)));

		// (0, 0)ւ̂S̓͂Ȁ݂ԂƓł邱ƂmFB
		assertEquals(true, mHandler.isSameInput(new Point(0, 0), String.valueOf(4)));
		
		// (0, 0)ɂS͂B
		assertEquals(false, mHandler.notifyInputOccured(String.valueOf(4)));

		// ՖʂύXĂȂƂmFB
		assertEquals(false, mModel.isModified());
		
		// ύXӏPӏł邱ƂmFB
		assertEquals(0, mModel.lastModified().length);

		setExpected("[ActiveSelectionState()][NumberState(4)]");
		setReal(parseDecoratedState(mModel.getCurStateAt(0, 0)));
	}
}