// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardModel.java
//	DATE:		2003.11.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.model;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;

import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ChangeEvent;

import jp.gr.java_conf.ktz.puzzle.fillo.util.StateEventUtility;

/**
 *	pY̔ՖʂǗNX
 */
public class BoardModel extends AbstractDecoratedModel {
	private static class Cell {
		private State  mState;
		private boolean mImmutable;
		
		Cell() {
			mState = getDefaultState();
		}
		
		State getState() {
			return mState;
		}
		
		void setState(State inState) {
			mState = inState;
		}

		private State getDefaultState() {
			return StateManager.getInstance().createDefaultState();
		}
		
		boolean isSpace() {
			return StateManager.getInstance().isSpaceState(mState);
		}
		
		boolean isNumber() {
			return StateManager.getInstance().isNumberState(mState);
		}
		
		void setImmutable() {
			mImmutable = true;
		}
		
		boolean isImmutable() {
			return mImmutable;
		}
	}
	
	private Cell[] mCells;
	private int mWidth;
	private int mHeight;
	
	private java.util.Set mLastModified = new java.util.HashSet();
	
	/**
	 *	ftHgRXgN^
	 */
	public BoardModel() {
		this(NullModel.getInstance());
	}
	
	/**
	 *	RXgN^
	 *	w肵ModelbvModelƂďLB
	 *	̃\bhāA
	 *	Model̉ɔzuꂽModelɑ΂āA\bh͓]Ȃ
	 */
	public BoardModel(Model inModel) {
		super(inModel);
	}
	
	/**
	 *	w肳ꂽTCỸ{[h쐬
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	protected void createBoardSelf(final int inWidth, final int inHeight) {
		if (inWidth == mWidth && inHeight == mHeight) return;
		
		// ύXSNA
		flushSelf();
		
		mWidth = inWidth;
		mHeight = inHeight;
		mCells = new Cell[mWidth * mHeight];
			
		for (int y = 0; y < mHeight; ++y) {
			for (int x = 0; x < mWidth; ++x) {
				mCells[y * mWidth + x] = new Cell();
				mLastModified.add(new Point(x, y));
			}
		}
	}
	
	/**
	 *	ݒ肷B
	 *
	 * 	@param	inProblem	̏
	 *	@return	ǂ݂񂾗vfBǂ݂܂ȂƂInteger.MIN_VALUEԂ
	 */
	public int setProblem(ProblemInfo inInfo) {
		// ̏ƃTCYقȂĂ΃{[h쐬ȂB
		if (mWidth != inInfo.getWidth() || mHeight != inInfo.getHeight()) {
			createBoard(inInfo.getWidth(), inInfo.getHeight());
		}
		
		// ȏǂݍނƂoȂꍇ
		if (! inInfo.isMoreRead()) return Integer.MIN_VALUE;
		
		int aReadPos = 0;
		if (inInfo.isDivideRead()) {
			aReadPos = inInfo.getOffset();
		}
		
		for (int i = aReadPos; i < aReadPos + inInfo.getReadOnce(); ++i) {
			State aState = idsToState((String)inInfo.getRecordAt(i));
			if (mCells[i].getState() != aState) {
				mCells[i].setState(aState);
				addModifiedSet(i);
			}
		}
		
		return (inInfo.isDivideRead() ? inInfo.getReadOnce() : Integer.MIN_VALUE);	
	}

	/**
	 *	w肳ꂽʒuɁAw肳ꂽ背R[h蓖āAB
	 *	̎ł́A背R[h͏ԂɑΉ镶IDłB
	 *	
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@param	inReocord	背R[h
	 *
	 *	@throws	IllegalArgumentExcedption	inX, inYՊOłꍇA܂inRecordnullłꍇ
	 */
	protected void initProblemAtSelf(final int inX, final int inY, Object inRecord) {
		if (! contains(inX, inY)) {
			throw new IllegalArgumentException(
				"0 < x <= " + mWidth + ", 0 < y <= " + mHeight + " (inX : " 
				+ inX + ", inY : " + inY + ")"
			);
		}
		if (null == inRecord) {
			throw new IllegalArgumentException(
				"Cannot pass null-value to inRecord"
			);
		}
		
		State aState = idsToState((String)inRecord);
		Cell aCell = getCellAt(inX, inY);
		if (aCell.getState() != aState) {
			aCell.setState(aState);
			addModifiedSet(inX, inY);
		}
		
		if (aCell.isNumber()) {
			aCell.setImmutable();
		}
	}
	
	private State idsToState(String inIDs) {
		final State aState = StateManager.getInstance().createStateOf(inIDs.trim());

		if (aState == null) {
			throw new IllegalArgumentException("A specified ID \'" + inIDs.trim() + "\' is ignore.");
		}
		
		return aState;
	}
	
	private void addModifiedSet(final int inIndex) {
		final int aX = inIndex % mWidth;
		final int aY = inIndex / mWidth;
		
		addModifiedSet(aX, aY);
	}

	private void addModifiedSet(final int inX, final int inY) {
		mLastModified.add(new Point(inX, inY));
	}

	/**
	 *	݂̏Ԃǂ`FbN
	 *
	 *	@return ȂtrueԂ
	 */
	public boolean check() {
		return false;
	}

	/**
	 *	Ԃɖ߂
	 */
	public void reset() {
	}
	
	/**
	 *	w肵ʒuԂɖ߂
	 */
	protected void resetAtSelf(final int inX, final int inY) {
	}
	
	/**
	 *	{[h̃TCYԂ 
	 *
	 *	@return TCY
	 */
	public java.awt.Dimension getSize() {
		return new java.awt.Dimension(mWidth, mHeight);
	}
	
	/**
	 *	{[h̕Ԃ
	 * 
	 *	@return 
	 */
	public int getWidth() {
		return mWidth;
	}
	
	/**
	 *	{[h̍ԂB
	 * 
	 *	@return 
	 */
	public int getHeight() {
		return mHeight;
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ̏ԂԂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return 
	 *
	 *	@throws	ArrayIndexOutOfBoundsException ՊOw肳ꂽꍇɑo
	 */
	public State getCurStateAt(final int inX, final int inY) {
		return getCellAt(inX, inY).getState();
	}
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1i߂B
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoꍇ
	 *	@deprecated ̃\bhĂяoꍇ
	 */
	public void nextStateAt(final int inX, final int inY) {
		// nextԑJڂinEventKw肷B
		throw new UnsupportedOperationException(
				"Needs to pass a arg inEvent for the method nextStateAt."
		);
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏ԂStateEventCodeɂ1i߂B
	 *	
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@param	inEvent	JڂɊւl
	 */
	protected void nextStateAtSelf(final int inX, final int inY, StateEventCode inCode) {	
		if (! StateEventUtility.isNumberStateEventCode(inCode)) {
			throw new IllegalArgumentException("inCode is not NumberStateEventCode");
		}
		
		Cell aCell = getCellAt(inX, inY);
		
		// ͈ʒu̐łꍇAԂύXȂB
		if (aCell.isImmutable()) return;
		
		State aNextState = StateManager.getInstance().getNextState(aCell.getState(), inCode);
		
		if (aCell.getState() != aNextState) {
			aCell.setState(aNextState);
			mLastModified.add(new Point(inX, inY));
		}
	}
	
	/** 
	 * w肳ꂽʒu̖ʂ̏Ԃ1߂B
	 *
	 * @param	inX	XW
	 * @param	inY	YW
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoꍇ
	 *	@deprecated ̃\bhĂяoꍇ
	 */
	public void prevStateAt(final int inX, final int inY) {
		throw new UnsupportedOperationException(
				"Needs to pass a arg inEvent for the method prevStateAt."
		);
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏ԂinEventlɂ1߂B
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@param	inEvent	JڂɊւl
	 */
	protected void prevStateAtSelf(final int inX, final int inY, StateEventCode inEvent) {
		throw new UnsupportedOperationException();
	}
	
	/** 
	 *	ŌɏCʂ̈ʒuԂB
	 *
	 *	@return ŌɏCʂ̈ʒu̔z
	 */
	protected synchronized java.awt.Point[] lastModifiedSelf() {
		return (Point[])mLastModified.toArray(new Point[mLastModified.size()]);
	}
	
	/**
	 *	ModelύXꂽǂ𒲂ׂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	protected synchronized boolean isModifiedSelf() {
		return ! mLastModified.isEmpty();
	}
	
	/**
	 *	Model̕ύXNA
	 */
	protected synchronized void flushSelf() {
		if (mLastModified.isEmpty()) return;
		
		mLastModified.clear();
	}
	
	/**
	 *	w肳ꂽʒu̖ʂǂׂB
	 *	̎ł́ABoadOw肳ꂽꍇ́AfalseԂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return	Ȃtrue
	 */
	public boolean isNumberAt(final int inX, final int inY) {
		if (! contains(inX, inY)) return false;

		return getCellAt(inX, inY).isNumber();
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ󔒂ǂׂB
	 *	̎ł́ABoadOw肳ꂽꍇ́AfalseԂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return	󔒂Ȃtrue
	 */
	public boolean isSpaceAt(final int inX, final int inY) {
		if (! contains(inX, inY)) return false;

		return getCellAt(inX, inY).isSpace();
	}

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *	̎ł́ABoadOw肳ꂽꍇ́AfalseԂB
	 *
	 *	@param	inX XW
	 *	@param	inY YW
	 *	@param	inTransitCode JڂɊւl
	 *	@return	Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransitAt(
			final int inX, final int inY, 
			StateEventCode inTransitCode)
	{
		if (! contains(inX, inY)) return false;

		throw new UnsupportedOperationException();
	}

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *	̎ł́Ã\bhĂяoƂAɗO𑗏o
	 *
	 *	@param	inX XW
	 *	@param	inY YW
	 *	@return	Jڂł̂ł΁AtrueԂB
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoƂ
	 *	@deprecated ̃\bhĂяoꍇ
	 */
	public boolean isTransitAt(final int inX, final int inY) {
		throw new UnsupportedOperationException("the method isTransitAt(int, int) is unsupported");
	}

	/**
	 *	w肳ꂽStateEventCodẽfŏł邩ǂ`FbNB
	 *
	 *	@param	inCode`FbNStateEventCode
	 *	@return	̃fŏł̂ł΁AtrueԂ
	 */
	protected boolean isAcceptableEvent(StateEventCode inCode) {
		return (StateEventUtility.isNumberStateEventCode(inCode) ? true : false);
	}
	
	/**
	 *	w肳ꂽʒu{[ḧǂׂ 
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@return	{[ḧȂtrue
	 */
	public boolean contains(final int inX, final int inY) {
		return (inX >= 0 && inX < mWidth && inY >= 0 && inY < mHeight);
	}

	/**
	 *	w肵ʒũZ̐ԂԂB
	 *	̎ł́Ã\bh͎gpȂ
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoƂ
	 *	@deprecated ̃\bhĂяoꍇ
	 */
	public State getCorrectStateAt(final int inX, final int inY) {
		throw new UnsupportedOperationException(
				"This model isnot supported getCorrectStateAt method."
		);
	}
	
	private Cell getCellAt(final int inX, final int inY) {
 		if (! contains(inX, inY)) {
 			throw new IndexOutOfBoundsException(
				"0 <= x < " + mWidth + ", 0 <= y < " + mHeight + " (inX : " 
				+ inX + ", inY : " + inY + ")"
			);
		}
		
		return mCells[inY * mWidth + inX];
 	}
 }