// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		EditableNumberStateManagerImpl.java
//	DATE:		2003.11.17
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.model;

import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.DecoratedStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.NumberState;

import jp.gr.java_conf.ktz.puzzle.fillo.util.StateEventUtility;

import jp.gr.java_conf.ktz.puzzle.fillo.constants.StateID;

public class EditableNumberStateManagerImpl extends DecoratedStateManagerImpl {
	/** 󔒂IDl */
	public final static String SPACE_ID = StateID.SPACE_ID;
	
	/** 
	 *	IDslƏԂ̑g}bvĂ 
	 *	ie Map<StateEventCode, State>
	 */
	private java.util.Map mStateMap = new java.util.HashMap();
	
	/** Jڌ̏ */
	private State mTransit;
	
	/**
	 *	RXgN^
	 */
	public EditableNumberStateManagerImpl() {
		this(null);
	}
	
	public EditableNumberStateManagerImpl(StateManagerImpl inManager) {
		super(inManager);
		
		initMap();
	}
	
	private void initMap() {
		final StateEventCode aCode = StateEventUtility.getNumberStateEventCode(SPACE_ID);
		mStateMap.put(aCode, SpaceState.getInstance());
	}
	
	/**
	 *	inStateIDlɑԂ쐬B
	 *
	 *	@param inStateID ԂɑΉID
	 *	@return inStateIDlɑԁB
	 */
	protected State createStateOfSelf(String inStateID) {
		final StateEventCode aCode = StateEventUtility.getNumberStateEventCode(inStateID);
		
		// }bvɓo^ĂȂꍇ́AIDł邽ߗO𑗏o
		if (aCode == null) {
			throw new IllegalArgumentException("The inStateID : \'" + inStateID + "\' is illegal.");
		}
		
		if (mStateMap.containsKey(aCode)) {
			return (State)mStateMap.get(aCode);
		}
		
		return idsToState(inStateID, aCode);
	}
	
	private State idsToState(String inIDs, StateEventCode inCode) {
		State aState = null;
		try {
			final int aNum = Integer.parseInt(inIDs);
			aState = new NumberState(aNum);
			
			mStateMap.put(inCode, aState);
		}
		catch (NumberFormatException e) {
			throw new IllegalArgumentException("The inStateID : " + inIDs + " is illegal.");
		}
		
		return aState;
	}
	
	/**
	 *	ftHg̏Ԃ쐬B
	 *	̎ł͋󔒏ԂԂB
	 *	
	 * @return ftHg
	 */
	protected State createDefaultStateSelf() {
		return createStateOfSelf(SPACE_ID);
	}
	
	/**
	 *	w肵ԂɑΉAIDԂB
	 *	́AcreateStateOf̋t̑łB
	 *
	 *	@param	inState ϊ
	 *	@return	ԂɑΉAID
	 */
	protected String findIdentityOfSelf(State inState) {
		java.util.Iterator aIt = mStateMap.entrySet().iterator();
		
		while (aIt.hasNext()) {
			java.util.Map.Entry aEntry = (java.util.Map.Entry)aIt.next();
			if (aEntry.getValue().equals(inState)) {
				return ((StateEventCode)aEntry.getKey()).getValue();
			}
		}
		
		return SPACE_ID;
	}
	
	/**
	 *	Ԃ1i߂B
	 *	̎ł́AJڂ͍sȂ
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	protected State getNextStateSelf(State inState) {
		throw new UnsupportedOperationException("getNextStateSelf(State) method is not supported.");
	}

	/**
	 *	Ԃ1i߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	protected State getNextStateSelf(State inState, StateEventCode inEvent) {
		return getTransitedState(inEvent);
	}

	/**
	 *	Ԃ1߂B
	 *	̎ł́AJڂ͍sȂ
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	protected State getPrevStateSelf(State inState) {
		throw new UnsupportedOperationException("getPrevStateSelf(State) method is not supported.");
	}
	
	/**
	 *	Ԃ1߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	protected State getPrevStateSelf(State inState, StateEventCode inEvent) {
		return getTransitedState(inEvent);
	}
	
	private State getTransitedState(StateEventCode inEvent) {
		final State aState = (State)mStateMap.get(inEvent);
		
		if (aState != null) return aState;
		
		return idsToState(inEvent.getValue(), inEvent);
	}
	
	/**
	 *	w肳ꂽԂł邩ǂ`FbNB
	 *
	 *	@param	inState `FbNState object
	 *	@return ԂłtrueԂB
	 */
	protected boolean isNumberStateSelf(State inState) {
		return (inState instanceof NumberState);
	}
	
	/**
	 *	w肳ꂽԂ󔒂ł邩ǂ`FbNB
	 *
	 *	@param	inState `FbNState object
	 *	@return Ԃ󔒂łtrueԂB
	 */
	protected boolean isSpaceStateSelf(State inState) {
		return (inState instanceof SpaceState);
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *	̎ł́AJڂ܂ł̃`FbN͍sȂB
	 *
	 *	@param inState `FbNState object
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	protected boolean isTransitSelf(State inState) {
		throw new UnsupportedOperationException("isTransitSelf(State) method is not supported.");
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *	̎ł́A֌WȂevent codenĂꍇA
	 *	܂݂͌̏ԂƑJڌ̏ԂꍇAfalseԂB
	 *
	 *	@param inState `FbNState object
	 *	@param inEvent ɓJڂ҂̂łΎw肷B
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	protected boolean isTransitSelf(State inState, StateEventCode inEvent) {
		return (mStateMap.get(inEvent) == inState ? false : true);
	}
	
	/**
	 *	w肵StateEventCodeStateManagerŏł邩ǂ`FbN
	 *
	 *	@param	inEvent	Cxg̎
	 *	@return	łꍇAtrueԂ
	 */
	protected boolean acceptableEventCode(StateEventCode inEvent) {
		return  StateEventUtility.isNumberStateEventCode(inEvent);
	}
}