// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SelectionModel.java
//	DATE:		2003.11.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.model;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.SelectionState;

import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;

import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ChangeEvent;

import jp.gr.java_conf.ktz.puzzle.fillo.fsm.ActiveSelectionState;

/**
 *	pY̔ՖʂǗNX
 */
public class SelectionModel extends AbstractDecoratedModel {
	private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
	private java.util.Set mModifiedSet = new java.util.HashSet();
	
	private Point mActivePos = ModelConstants.ILLEGAL_POS;
	private java.util.Set mSelectedSet = new java.util.HashSet();
	
	/**
	 *	RXgN^
	 *	w肵ModelbvModelƂďLB
	 *	̃\bhāA
	 *	Model̉ɔzuꂽModelɑ΂āA\bh͓]Ȃ
	 */
	public SelectionModel(Model inModel) {
		super(inModel);
	}
	
	/**
	 *	w肳ꂽTCỸ{[h쐬
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	protected void createBoardSelf(final int inWidth, final int inHeight) {
		if (! mSelectedSet.isEmpty()) {
			mSelectedSet.clear();
		}
		mActivePos = ModelConstants.ILLEGAL_POS;;
		
	}
	
		/**
	 *	w肳ꂽʒuɁAw肳ꂽ背R[h蓖āAB
	 *	
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@param	inReocord	背R[h
	 *
	 *	@throws	IllegalArgumentExcedption	inX, inYՊOłꍇA܂inRecordnullłꍇ
	 */
	protected void initProblemAtSelf(final int inX, final int inY, Object inReocord) {
	}

	/**
	 *	݂̏Ԃǂ`FbN
	 *
	 *	@return ȂtrueԂ
	 */
	public boolean check() {
		return false;
	}
	
	/**
	 *	w肵ʒuԂɖ߂
	 */
	protected void resetAtSelf(final int inX, final int inY) {
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ̏ԂԂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return 
	 */
	public State getCurStateAt(final int inX, final int inY) {
		State aState = super.getCurStateAt(inX, inY);
		
		Point aPos = new Point(inX, inY);
		if (mActivePos.equals(aPos)) {
			aState = new ActiveSelectionState(aState);
		}
		else if (mSelectedSet.contains(aPos)) {
			aState = new SelectionState(aState);
		}
		
		return aState;
	}
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1i߂B
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoꍇ
	 *	@deprecated ̃\bhĂяoꍇ
	 */
	public void nextStateAt(final int inX, final int inY) {
		// nextԑJڂinEventKw肷B
		throw new UnsupportedOperationException(
				"Needs to pass a arg inEvent for the method nextStateAt."
		);
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏ԂStateEventCodeɂ1i߂B
	 *	
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@param	inEvent	JڂɊւl
	 */
	protected void nextStateAtSelf(final int inX, final int inY, StateEventCode inEvent) {		
		ChangeEvent aEvent = (ChangeEvent)inEvent;
		
		mSelectedSet.clear();
		
		Point aNewSelPos = new Point(inX, inY);
		if (aEvent.isActivePos()) {
			if (aNewSelPos.equals(mActivePos)) return;
			
			// fANeBuɂ
			if (ModelConstants.ILLEGAL_POS != mActivePos) {
				mModifiedSet.add(mActivePos);
			}
			
			// ANeBuɂ
			mActivePos = aNewSelPos;
		}
		else {
			mSelectedSet.add(aNewSelPos);
		}
		
		mModifiedSet.add(aNewSelPos);
	}
	
	/** 
	 * w肳ꂽʒu̖ʂ̏Ԃ1߂B
	 *
	 * @param	inX	XW
	 * @param	inY	YW
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoꍇ
	 *	@deprecated ̃\bhĂяoꍇ
	 */
	public void prevStateAt(final int inX, final int inY) {
		throw new UnsupportedOperationException(
				"Needs to pass a arg inEvent for the method prevStateAt."
		);
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏ԂinEventlɂ1߂B
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@param	inEvent	JڂɊւl
	 */
	protected void prevStateAtSelf(final int inX, final int inY, StateEventCode inEvent) {
		throw new UnsupportedOperationException();
	}
	
	/** 
	 *	ŌɏCʂ̈ʒuԂB
	 *
	 *	@return ŌɏCʂ̈ʒu̔z
	 */
	protected synchronized java.awt.Point[] lastModifiedSelf() {
		if (! isModifiedSelf()) return NO_MODIFIED;
		
		return (Point[])mModifiedSet.toArray(new Point[mModifiedSet.size()]);
	}
	
	/**
	 *	ModelύXꂽǂ𒲂ׂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	protected synchronized boolean isModifiedSelf() {
		return (! mModifiedSet.isEmpty());
	}
	
	/**
	 *	Model̕ύXNA
	 */
	protected synchronized void flushSelf() {
		if (! mModifiedSet.isEmpty()) {
			mModifiedSet.clear();
		}
	}
	
	/**
	 *	w肳ꂽStateEventCodẽfŏł邩ǂ`FbNB
	 *
	 *	@param	inCode`FbNStateEventCode
	 *	@return	̃fŏł̂ł΁AtrueԂ
	 */
	protected boolean isAcceptableEvent(StateEventCode inCode) {
		if (!(inCode instanceof ChangeEvent)) return false;
		
		ChangeEvent aEvent = (ChangeEvent)inCode;
		return (aEvent.getEventType() == ChangeEvent.TYPE_SELECTION ? true :false);
	}
	
	/**
	 *	w肵ʒũZ̐ԂԂB
	 *	̎ł́Ã\bh͎gpȂ
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoƂ
	 *	@deprecated ̃\bhĂяoꍇ
	 */
	public State getCorrectStateAt(final int inX, final int inY) {
		throw new UnsupportedOperationException(
				"This model isnot supported getCorrectStateAt method."
		);
	}
	
}