// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		FilloBoardView.java
//	DATE:		2003.11.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Graphics;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Point;

import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;

import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.BoardView;
import jp.gr.java_conf.ktz.puzzle.framework.util.Command;
import jp.gr.java_conf.ktz.puzzle.framework.model.Model;

import jp.gr.java_conf.ktz.puzzle.fillo.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.fillo.app.model.SelectionModel;

import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderStrategy;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.FilloRenderStrategy;

import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ChangeHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.FilloChangeHandler;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.ProblemLoader;
import jp.gr.java_conf.ktz.puzzle.fillo.app.controller.FilloProblemLoader;

import jp.gr.java_conf.ktz.puzzle.fillo.constants.AppColors;

import jp.gr.java_conf.ktz.puzzle.fillo.util.InputUtility;


/**
 *	tBI~m̔Ֆʂ̌ĂǗNX
 */
public class FilloBoardView extends Canvas implements BoardView {
	private RenderStrategy mStrategy;
	private InputHandler mInputHandler;
	private ProblemLoader mProblemLoader;
	
	public FilloBoardView() {
	}
	
	// BoardView̎
	
	/**
	 *	Ֆʂ̏s
	 */
	public void initialize() {
		// Ֆʂ̍쐬
		Model aModel = new SelectionModel(new BoardModel());
		aModel.createBoard(7, 7);
		
		// RendererStrategy̏
		mStrategy = new FilloRenderStrategy(aModel);
		mStrategy.setSize(7, 7);
		mStrategy.setBackground(AppColors.BACK_COLOR);
		
		// Renderer̓o^
		mStrategy.installDefaultRenderer(new FilloDefaultRendererFactory());
		mStrategy.installRenderer(new FilloStateRendererFactory());
		
		// AWTCxgXi[̓o^
		FilloInputHandler aInputHandler = new FilloInputHandler(aModel);
		addMouseListener(aInputHandler);
		addKeyListener(aInputHandler);
		mInputHandler = aInputHandler;
		
		// ProblemLoadeȑ
		mProblemLoader = new FilloProblemLoader(aModel);
		
		// Iterationł́A܂Hard-Coding
		mProblemLoader.loadProblem(new ProblemInfo("untitled", 0, 4, 5, "4, s, 2, s, s, s, s, 2, s, s, s, s, s, 2, s, 4, 1, s, s, 3".split(",")));

		// (0, 0)IԂɂB
		mInputHandler.resetActivePos(0, 0);
		
		// Ă̏
		setBackground(AppColors.BACK_COLOR);
		setSize(mStrategy.getBoardSize());
		
		
	}
	
	/**
	 *	BoardKwƂÅKw̐eݒ肷
	 *
	 *	@param	inBoard	̊Kw̐eƂȂBoard
	 */
	public void setParent(BoardView inBoard) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 *	ՖʂύXĂ邩ǂ`FbNB
	 */
	public boolean isModified() {
		throw new UnsupportedOperationException();
	}
	
	/**
	 *	@return	gƊ֘AtꂽComponentԂ
	 */
	public Component getComponent() {
		return this;
	}
	
	/**
	 *	BoardɃtH[JXڂǂ߂
	 */
	public void setFocus(boolean inFocused) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 *	BoardɃtH[JX݂邩ǂ`FbN
	 *
	 *	@return	tH[JXꍇtrueԂB
	 */
	public boolean isFocused() {
		throw new UnsupportedOperationException();
	}
	
	// CommandContainer̎
	
	/**
	 *	Commands
	 *
	 *	@param	inCommand	Command
	 */
	public void processCommand(Command inCommand) {
		throw new UnsupportedOperationException();
	}

	// Canvas̎
	
	public void update(Graphics inGra) {
		paint(inGra);
	}
	
	public void paint(Graphics inGra) {
		inGra.drawImage(mStrategy.render(), 0, 0, this);
	}
	
	private class FilloInputHandler implements InputHandler, 
											MouseListener, KeyListener 
	{
		ChangeHandler mHandler;
		
		FilloInputHandler(Model inModel) {
			mHandler = new FilloChangeHandler(inModel);
		}
	
		/**
		 *	ANeBu|WVw肵ʒuŏB
		 */
		public void resetActivePos(final int inX, final int inY) {
			mHandler.notifySelectionChanged(inX, inY, false, false);
		}

		public void mouseClicked(MouseEvent inEvent) {
			boolean aModified = false;
			
			final int aCount = inEvent.getClickCount();
			if (aCount == 1) {
				Point aPos = mStrategy.calcPortToBoardPos(inEvent.getX(), inEvent.getY());
				aModified = mHandler.notifySelectionChanged(aPos.x, aPos.y, false, false);
			}
			else if (aCount == 2) {
				System.out.println("mouse double clicked !!");
			}
			
			if (aModified) {
				Rectangle aClip = mStrategy.getClipBounds();
				repaint(aClip.x, aClip.y, aClip.width, aClip.height);
			}
		}
		
		public void keyTyped(KeyEvent inEvent) {
			final int aPressedCode = inEvent.getKeyChar();
			
			boolean aModified = false;
			
			if (InputUtility.availableInputKey(aPressedCode)) {
				aModified = mHandler.notifyInputOccured(InputUtility.convertValueFor(aPressedCode));
			}
			
			if (aModified) {
				Rectangle aClip = mStrategy.getClipBounds();
				repaint(aClip.x, aClip.y, aClip.width, aClip.height);
			}
		}
		
		public void mouseReleased(MouseEvent inEvent) {}
		
		public void mousePressed(MouseEvent inEvent) {}
		public void mouseEntered(MouseEvent inEvent) {}
		public void mouseExited(MouseEvent inEvent) {}
		
		public void keyPressed(KeyEvent inEvent) {}
		public void keyReleased(KeyEvent inEvent) {}
	}
}
