// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		FilloRendererLocator.java
//	DATE:		2003.11.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.util.Map;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Color;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.NullState;

import jp.gr.java_conf.ktz.puzzle.fillo.constants.AppColors;

import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RendererLocator;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.Renderer;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderEvent;

/**
 *	tBI~m̔Ֆʂ`悷Renderero^AT邽߂̃NX
 */
public class FilloRendererLocator implements RendererLocator {
	private Map mTable = new java.util.HashMap();
	
	public FilloRendererLocator() {
		mTable.put(NullState.class, new Renderer() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				Color aBackColor = inEvent.getBackColor();
				
				aGra.setColor(aBackColor);
				aGra.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		});
	}
	
	/**
	 *	w肳ꂽԂɑΉARendererT
	 *	ΉRendererȂꍇADefaultRendererԂB
	 *
	 *	@param	inState	TΏۂ̏
	 *
	 *	@return	ΉRenderListenerԂB
	 *
	 *	@throws	IllegalArgumentException inStatenull̏ꍇɑoB
	 */
	public Renderer lookup(State inState) {
		if (inState == null) {
			throw new IllegalArgumentException();
		}
		
		Class aKey = inState.getClass();
		
		if (! mTable.containsKey(inState.getClass())) {
			aKey = NullState.class;
		}
		
		return (Renderer)mTable.get(aKey);
	}
	
	/**
	 *	@return ΉԂȂꍇɎgpRendererԂ
	 */
	public Renderer getDefaultRenderer() {
		return (Renderer)mTable.get(NullState.class);
	}
	
	/**
	 *	LocatorRendererFactoryRenderero^
	 *
	 *	@param	inFactory	Renderer쐬Factory Method
	 *
	 *	@throws	IllegalArgumentException inFactorynull̏ꍇɑoB
	 */
	public void installRenderer(RendererFactory inFactory) {
		inFactory.install(this);
	}

	/**
	 *	ΉԂȂꍇɎgpRenderero^B
	 *
	 *	@throws	IllegalArgumentException	inRenderernull̏ꍇɑoB
	 */
	public void installDefaultRenderer(AbstractDefaultRendererFactory inFactory) {
		inFactory.install(this);
	}
	
	/**
	 *	w肳ꂽԂɑΉw肳ꂽRendererLocatorɓo^B
	 *	̎ł́Aɓo^ĂꍇA㏑B
	 *
	 *	@param	inClass	̃L[ƂȂԂClassIuWFNg
	 *	@param	inRenderer	w肳ꂽԂ`悷Renderer
	 *
	 *	@throws	IllegalArgumentException  nꂽ̂ǂ炩null̏ꍇɑo
	 */
	public void addRenderer(Class inClass, Renderer inRenderer) {
		mTable.put(inClass, inRenderer);
	}
}
