// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		MockedDefaultRendererFactory.java
//	DATE:		2003.11.18
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Rectangle;

import junit.framework.Assert;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.framework.fsm.NullState;

import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RendererFactory;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RendererLocator;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.Renderer;
import jp.gr.java_conf.ktz.puzzle.fillo.app.view.RenderEvent;

import jp.gr.java_conf.ktz.puzzle.fillo.fsm.ActiveSelectionState;

import jp.gr.java_conf.ktz.puzzle.fillo.util.TestUtility;

/**
 *	ՖʃobN̕`sRenderer쐬Factory Method
 */
class MockedDefaultRendererFactory implements RendererFactory {
	String mExpectedValue;
	
	/**
	 *	Renderer쐬ARendererLocatorɓo^
	 *
	 *	@partam	inLocator	o^ƂȂRendererLocator
	 *
	 *	@throws	IllegalArgumentException inLocatornull̏ꍇAoB
	 */
	public void install(RendererLocator inLocator) {
		inLocator.addRenderer(NullState.class, new Renderer() {
			public void render(RenderEvent inEvent) {
				setActual(debugWriteMessage(inEvent, NullState.class));
			}
		});
		
		inLocator.addRenderer(SpaceState.class, new Renderer() {
			public void render(RenderEvent inEvent) {
				setActual(debugWriteMessage(inEvent, SpaceState.class));
			}
		});
		
		inLocator.addRenderer(NumberState.class, new Renderer() {
			public void render(RenderEvent inEvent) {
				setActual(debugWriteMessage(inEvent, NumberState.class));
			}
		});
		
		inLocator.addRenderer(ActiveSelectionState.class, new Renderer() {
			public void render(RenderEvent inEvent) {
				setActual(debugWriteMessage(inEvent, ActiveSelectionState.class));
			}
		});
		
	}
	
	private String debugWriteMessage(RenderEvent inEvent, Class inClass) {
		State aState = inEvent.getState();
		
		Assert.assertEquals(inClass, aState.getClass());
		
		Rectangle aBounds = inEvent.getBounds();
		
		return "Rendered "  + TestUtility.parseDecoratedState(inEvent.getState())
				+ " ranging from " + toPosString(aBounds.x, aBounds.y)
				+ " to " + toPosString(aBounds.x+aBounds.width, aBounds.y+aBounds.height);
	}
	
	private String toPosString(final int inX, final int inY) {
		return "(" + inX + ", " + inY + ")";
	}
	
	public void setExpected(String inValue) {
		mExpectedValue = inValue;
	}
	
	public void setActual(String inValue) {
		Assert.assertNotNull(mExpectedValue);
		Assert.assertNotNull(inValue);
		Assert.assertEquals(mExpectedValue, inValue);
	}
}
