// ***************************************************************************************
//
//	Copyright (C) 2003, Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		RenderEvent.java
//	DATE:		2003.11.14
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.app.view;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Color;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;

/**
 *	RenderListenerɓnp[^
 */
public final class RenderEvent {
	private RendererLocator mLocator;
	private Graphics mGraphics;
	private Color mBackColor;
	private Rectangle mBounds;
	private State mState;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inLocator ԂKwĂꍇɃTuԂRenderListener擾邽߂̂́B
	 *	@param	inGra ĕ`ΏۂƂȂGraphicsIuWFNgB
	 *	@param	inBackColor obNOEhJ[B
	 *	@param	inBounds ĕ`悷ׂՖʂ̗̈iscreenWnjB
	 *	@param	inState `悵ԁB
	 */
	public RenderEvent(
			RendererLocator inLocator, Graphics inGra, Color inBackColor, 
			Rectangle inBounds, State inState) 
	{
		reset(inLocator, inGra, inBackColor, inBounds, inState);
	}
	
	/**
	 *	w肵RenderEventZbgB
	 *
	 *	@param	inLocator ԂKwĂꍇɃTuԂRenderListener擾邽߂̂́B
	 *	@param	inGra ĕ`ΏۂƂȂGraphicsIuWFNgB
	 *	@param	inBackColor obNOEhJ[B
	 *	@param	inBounds ĕ`悷ׂՖʂ̗̈iscreenWnjB
	 *	@param	inState `悵ԁB
	 */
	public void reset(
			RendererLocator inLocator, Graphics inGra, Color inBackColor, 
			Rectangle inBounds, State inState) 
	{
		mLocator = inLocator;
		mGraphics = inGra;
		mBackColor = inBackColor;
		mBounds = inBounds;
		mState = inState;
	}
	
	/**
	 *	@return	p[^FRendererLocatorԂ
	 */
	public RendererLocator getLocator() {
		return mLocator;
	}

	/**
	 *	p[^Fĕ`ΏۂƂȂGraphicsIuWFNgAԂB
	 *
	 *	@return	ĕ`ΏۂƂȂGraphicsIuWFNgB
	 */
	public Graphics getGraphics() {
		return mGraphics;
	}
	
	/**
	 *	@return obNOEhJ[ԂB
	 */
	public Color getBackColor() {
		return mBackColor;
	}
	/**
	 *	p[^Fĕ`悷ׂՖʂ̗̈AԂ
	 *
	 *	@return	ĕ`悷ׂՖʂ̈ʒuB
	 */
	public Rectangle getBounds() {
		return mBounds;
	}
		
	/**
	 *	p[^F`悵ԁAԂB
	 *
	 *	@return	`悵ԁB
	 */
	public State getState() {
		return mState;
	}	
}