// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		InputUtility.java
//	DATE:		2003.12.2
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.util;

import java.awt.event.KeyEvent;

public class InputUtility {
	/**
	 *	Ֆʂ֓͂𐔒lɕϊB
	 *
	 *	@throws	NumberFormatException	ƂĐȊOnꂽꍇ
	 */
	public static int getInputValue(String inVal) {
		return Integer.parseInt(inVal);
	}
	
	/**
	 *	͂폜ł邩ǂ`FbN
	 *	
	 *	@param	inVal	镶
	 *
	 *	@return ͂폜ł΁AtrueԂB
	 */
	public static boolean isDeleteOccured(String inVal) {
		return ("s".equals(inVal) ? true : false);
	}
	
	/**
	 *	͂L[R[hՖʂւ̓͂ƂāA
	 *	󂯓邱Ƃł邩ǂ`FbNB
	 */
	public static boolean availableInputKey(final int inKeyCode) {
		if (KeyEvent.VK_0 <= inKeyCode && KeyEvent.VK_9 >= inKeyCode) return true;
		
		return (KeyEvent.VK_BACK_SPACE == inKeyCode || KeyEvent.VK_DELETE == inKeyCode ? true : false);
	}
	
	/**
	 *	w肳ꂽL[R[hAՖʂւ͕̓ɕϊB
	 *
	 *	@throws	IllegalArgumentException	w肳ꂽL[R[hՖʂ̓͂ƂĕsK؂łꍇB
	 */
	public static String convertValueFor(final int inKeyCode) {
		if (KeyEvent.VK_0 <= inKeyCode && KeyEvent.VK_9 >= inKeyCode) {
			return KeyEvent.getKeyText(inKeyCode);
		}
		
		if (KeyEvent.VK_BACK_SPACE == inKeyCode || KeyEvent.VK_DELETE == inKeyCode) {
			return "s";
		}
		
		throw new IllegalArgumentException("A specified key code, " + inKeyCode + " is not available");
	}
	/**
	 *	͂L[R[hANeBu|WV̈ړ̓͂ƂāA
	 *	󂯓邱Ƃł邩ǂ`FbNB
	 */
	public static boolean availableCursorKey(final int inKeyCode) {
		if (KeyEvent.VK_LEFT == inKeyCode) return true;
		if (KeyEvent.VK_RIGHT == inKeyCode) return true;
		if (KeyEvent.VK_UP == inKeyCode) return true;
		if (KeyEvent.VK_DOWN == inKeyCode) return true;
		
		return true;
	}
}