// ***************************************************************************************
//
//	copyright (c) 2003, Kazuhiko TAMURA All rights reserved. 
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		NumberStateEventCode.java (package private class)
//	DATE:		2003.11.17
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.fillo.util;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.fillo.constants.StateID;

class NumberInputEvent implements StateEventCode {
	public final static String SPACE_ID = StateID.SPACE_ID;
	
	private static final StateEventCode ILLEGAL_CODE = new NumberInputEvent("");
	
	/**
	 *	IDStateEventCode}bsO
	 *	Map<String, StateEventCode>
	 */
	private static java.util.Map sEventMap = new java.util.HashMap();
	
	static {
		sEventMap.put(SPACE_ID, new NumberInputEvent(SPACE_ID));
	}
	
	private String mValue;
	
	private NumberInputEvent(String inValue) {
		mValue = inValue;
	}
	
	/**
	 *	w肳ꂽIDɑ΂StateEventCodeoB
	 *	̎ł́AΉStateEventCode݂ȂꍇAw肳ꂽID
	 *	Ƀp[XłꍇAo^ŁAԂB
	 *	łȂꍇ́AnullԂB
	 */
	static StateEventCode toEventCode(String inIDs) {
		if (sEventMap.containsKey(inIDs)) {
			return (StateEventCode)sEventMap.get(inIDs);
		}
		
		StateEventCode aCode = null;
		try {
			Integer.parseInt(inIDs);
			
			aCode = new NumberInputEvent(inIDs);
			sEventMap.put(inIDs, aCode);
		}
		catch (NumberFormatException e) {
			// empty
		}
		
		return aCode;
	}
	
	public String getValue() {
		return mValue;
	}
	
	public String toString() {
		return getClass() + " of \'" + getValue() + "\'";
	}
}