//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	NAME:		StateManagerImpl.java
//	DATE:		2003.5.29
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;

/**
 *	ԑJڃ}l[W[̎̂̃C^[tF[X
 *	AvP[VƂɎ
 *	<code>puzzle.framework.StateManager.initialize(StateManagerImpl inImpl)<code>
 *	̈Ɏw肷邱ƂŁAԑJڃ}l[W[邱ƂłB
 */
public interface StateManagerImpl {
	/**
	 *	inStateIDlɑԂ쐬B
	 *
	 *	@param inStateID ԂɑΉID
	 *	@return inStateIDlɑԁB
	 */
	public State createStateOf(String inStateID);
	
	/**
	 *	ftHg̏Ԃ쐬B
	 *	
	 * @return ftHg
	 */
	public State createDefaultState();
	
	/**
	 *	w肵ԂɑΉAIDԂB
	 *	́AcreateStateOf̋t̑łB
	 *
	 *	@param	inState ϊ
	 *	@return	ԂɑΉAID
	 */
	public String findIdentityOf(State inState);
	
	/**
	 *	Ԃ1i߂B
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	public State getNextState(State inState);

	/**
	 *	Ԃ1i߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	public State getNextState(State inState, StateEventCode inEvent);

	/**
	 *	Ԃ1߂B
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	public State getPrevState(State inState);
	
	/**
	 *	Ԃ1߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	public State getPrevState(State inState, StateEventCode inEvent);

	
	/**
	 *	w肳ꂽԂł邩ǂ`FbNB
	 *
	 *	@param	inState `FbNState object
	 *	@return ԂłtrueԂB
	 */
	public boolean isNumberState(State inState);
	
	/**
	 *	w肳ꂽԂ󔒂ł邩ǂ`FbNB
	 *
	 *	@param	inState `FbNState object
	 *	@return Ԃ󔒂łtrueԂB
	 */
	public boolean isSpaceState(State inState);
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *	̎ł́AJڂ܂ł̃`FbN͍sȂB
	 *
	 *	@param inState `FbNState object
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransit(State inState);
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *
	 *	@param inState `FbNState object
	 *	@param inEvent ɓJڂ҂̂łΎw肷B
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransit(State inState, StateEventCode inEvent);
}
