//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	NAME:		Model.java
//	DATE:		2003.5.27
//	MODIFIED	2003.8.16	w肵ʒuł悤resetAt()\bhǉ
//	MODIFIED	2003.8.17	setProblem()\bhɂāAǂ݂񂾗vfԂ悤ɕύX
//	MODIFIED	2003.8.30	ModelgԂ悤ɕύX(optional operation)
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework.model;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.ModelState;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.framework.fsm.State;

/**
 *	Ֆʂ̓ԂǗ邽߂̃C^[tF[X
 */
public interface Model {
	/**
	 *	w肳ꂽTCỸ{[h쐬
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	public void createBoard(final int inWidth, final int inHeight);
	
	/**
	 *	ݒ肷
	 *
	 * 	@param	inProblem	̏
	 *	@return	ǂ݂񂾗vf
	 */
	public int setProblem(ProblemInfo inProblem);
	
	/**
	 *	w肳ꂽʒuɁAw肳ꂽ背R[h蓖āAB
	 *	
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@param	inReocord	背R[h
	 *
	 *	@throws	IllegalArgumentExcedption	inX, inYՊOłꍇA܂inRecordnullłꍇ
	 */
	public void initProblemAt(final int inX, final int inY, Object inRecord);
	
	/**
	 *	݂̏Ԃǂ`FbN
	 *
	 *	@return ȂtrueԂ
	 */
	public boolean check();
	
	/**
	 *	Ԃɖ߂
	 */
	public void reset();
	
	/**
	 *	w肵ʒuԂɖ߂
	 */
	public void resetAt(final int inX, final int inY);
	
	/*
	 *	Model̏ԂύX(optional operation)
	 *
	 *	@param	inState	ύX̏
	 */
	public void setModelState(ModelState inState);
	
	/**
	 *	{[h̃TCYԂ 
	 *
	 *	@return TCY
	 */
	public java.awt.Dimension getSize();
	
	/**
	 *	{[h̕Ԃ 
	 *
	 *	@return 
	 */
	public int getWidth();
	
	/**
	 *	{[h̍Ԃ 
	 *
	 *	@return 
	 */
	public int getHeight();
	
	/**
	 *	w肳ꂽʒu̖ʂ̏ԂԂB
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@return 
	 */
	public State getCurStateAt(final int inX, final int inY);
	
	/**
	 *	w肳ꂽʒu̖ʂ̐ԂB
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@return ̏
	 *
	 *	@throws	IllegalArgumentExcedption	inX, inYՊOłꍇ
	 */	
	public State getCorrectStateAt(final int inX, final int inY);

	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1i߂ 
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *
	 *	@throws	IllegalArgumentExcedption	inX, inYՊOłꍇ
	 */
	public void nextStateAt(final int inX, final int inY);
	
	/**
	 *	w肵Ֆʂ̈ʒȕԂɑJڂB
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 *
	 *	@throws	IllegalArgumentExcedption	inX, inYՊOłꍇ
	 */
	public void nextStateAt(final int inX, final int inY, StateEventCode inCode);
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂ 
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *
	 *	@throws	IllegalArgumentExcedption	inX, inYՊOłꍇ
	 */
	public void prevStateAt(final int inX, final int inY);

	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 *
	 *	@throws	IllegalArgumentExcedption	inX, inYՊOłꍇ
	 */
	public void prevStateAt(final int inX, final int inY, StateEventCode inCode);
	
	/** 
	 *	@return ŌɏCʂ̈ʒuԂ
	 */
	public java.awt.Point[] lastModified();
	
	/**
	 *	w肳ꂽʒu{[ḧǂׂ 
	 *
	 *	@param	inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	{[ḧȂtrue
	 */
	public boolean contains(final int inX, final int inY);
	
	/**
	 *	w肳ꂽʒu̖ʂǂׂ 
	 *
	 *	@param	inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	Ȃtrue
	 */
	public boolean isNumberAt(final int inX, final int inY);
	
	/**
	 *	w肳ꂽʒu̖ʂ󔒂ǂׂB
	 *
	 *	@param inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	󔒂Ȃtrue
	 */
	public boolean isSpaceAt(final int inX, final int inY);

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *
	 *	@param inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransitAt(final int inX, final int inY);

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *	Jڂ܂Ŋł邩ǂׂB
	 *
	 *	@param	inCode JڂɊւl
	 *	@param inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransitAt(final int inX, final int inY, StateEventCode inCode);

	/**
	 *	ModelύXꂽǂ𒲂ׂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	public boolean isModified();
	
	/**
	 *	Model̕ύXNA
	 */
	public void flush();
}	
	