/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */
package jp.finaluna.api.type;

import jp.finaluna.api.blogic.BLogicCode;
import jp.finaluna.api.blogic.DAOCode;
import jp.finaluna.api.blogic.DTOCode;
import jp.finaluna.api.dao.DAO;
import jp.finaluna.api.dao.QueryCode;
import jp.finaluna.api.dto.DTO;

/**
 * Finaluna^𐶐ׂ̃t@NgC^tF[XB
 * 
 * <p>
 * Finaluna^𐶐t@NgNX́AConstantTypeFactoryC^tF[XB
 * </p>
 * 
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public interface ConstantFactoryDelegate {

    /**
     * BLogicCode𐶐B
     * 
     * @param <REQ> DTO
     * @param <RES> DTO
     * @param value l
     * @return BLogicCode
     */
    < REQ extends DTO, RES extends DTO > BLogicCode < REQ, RES > createBLogicCode(String value);

    /**
     * DAOCode𐶐B
     * 
     * @param <T> DAO
     * @param value l
     * @return DAOCode
     */
    < T extends DAO > DAOCode < T > createDAOCode(String value);

    /**
     * DateAndTimeType𐶐B
     * 
     * @param value l
     * @return DateAndTimeType
     */
    DateAndTimeType createDateAndTimeType(String value);

    /**
     * DateType𐶐B
     * 
     * @param value l
     * @return DateType
     */
    DateType createDateType(String value);

    /**
     * DecimalType𐶐B
     * 
     * @param value l
     * @return DecimalType
     */
    DecimalType createDecimalType(String value);

    /**
     * DTOCode𐶐B
     * 
     * @param <T> DTO
     * @param value l
     * @return DTOCode
     */
    < T extends DTO > DTOCode < T > createDTOCode(String value);

    /**
     * IntegerType𐶐B
     * 
     * @param value l
     * @return IntegerType
     */
    IntegerType createIntegerType(String value);

    /**
     * QueryCode𐶐B
     * 
     * @param <T> DTO
     * @param value l
     * @return QueryCode
     */
    < T extends DTO > QueryCode < T > createQueryCode(String value);

    /**
     * StringCode𐶐B
     * 
     * @param value l
     * @return StringCode
     */
    StringCode createStringCode(String value);

    /**
     * StringType𐶐B
     * 
     * @param value l
     * @return StringType
     */
    StringType createStringType(String value);

    /**
     * TimestampType𐶐B
     * 
     * @param value l
     * @return TimestampType
     */
    TimestampType createTimestampType(String value);

    /**
     * TimeType𐶐B
     * 
     * @param value l
     * @return TimeType
     */
    TimeType createTimeType(String value);

}
