/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_TEXTIMAGE_HEADER__
#define __FK_TEXTIMAGE_HEADER__

#include <FK/Image.h>
#include <FK/UniCode.h>
#include <FK/Material.h>

#include <string>
#include <vector>

class fk_FTGlyph;
class fk_FTFace;

enum fk_TextAlign {
	FK_ALIGN_LEFT,
	FK_ALIGN_CENTER,
	FK_ALIGN_RIGHT
};

enum fk_TextSendingMode {
	FK_SENDING_ALL,
	FK_SENDING_CHAR,
	FK_SENDING_LINE
};

class fk_TextImage : public fk_Image {
 private:

	fk_FTFace				*face;
	int						dpi, ptsize;
	int						boldStrength;
	int						lineSkip, charSkip, spaceLineSkip;
	int						maxHeight, maxWidth;
	vector<fk_Rect>			lineArray;
	vector<fk_Rect>			charArray;
	vector<int>				lineMap;
	int						minWidth;
	int						upOffset, downOffset, leftOffset, rightOffset;
	bool					smoothFlg;
	fk_Color				fgColor, bgColor, shadowColor;
	fk_TextAlign			alignMode;
	vector<fk_Image *>		charImages;
	fk_TextSendingMode		sendingMode;
	int						sendPos;
	bool					shadowMode;
	fk_Dimension			shadowOffset;
	fk_UniStr				strData;

	int						LayoutGlyphs(vector<fk_FTGlyph *> *);
	void					DumpRasterMap(int, int *, int *,
										  vector<fk_FTGlyph *> *);
	void					FreeGlyph(vector<fk_FTGlyph *> *);

	void					CalcTextOffset(void);
	void					ReCalcCharOffset(void);
	void					InitTextImage(void);
	void					CopyCharImage(int);
	void					ClearCharImages(void);
	void					MakeColorScale(const fk_Color &,
										   const fk_Color &,
										   int *);
 public:
	fk_TextImage(void);
	~fk_TextImage();

	bool				initFont(const string);
	bool				loadUniStr(fk_UniStr *);
	bool				loadStrFile(const string,
									fk_StringCode = FK_STR_UTF16);
	bool				send(void);
	bool				finish(void);
	bool				clear(void);

	void				setDPI(int);
	void				setPTSize(int);
	void				setCharSkip(int);
	void				setLineSkip(int);
	void				setSpaceLineSkip(int);
	void				setSmoothFlg(bool);
	void				setSmoothMode(bool);
	void				setForeColor(fk_Color);
	void				setForeColor(float, float, float, float);
	void				setForeColor(double, double, double, double);
	void				setBackColor(fk_Color);
	void				setBackColor(float, float, float, float);
	void				setBackColor(double, double, double, double);
	void				setAlign(fk_TextAlign);
	void				setOffset(int, int, int, int);
	void				setMinLineWidth(int);
	void				setSendingMode(fk_TextSendingMode);
	void				setShadowMode(bool);
	void				setShadowOffset(int, int);
	void				setShadowColor(fk_Color);
	void				setShadowColor(float, float, float, float);
	void				setShadowColor(double, double, double, double);
	void				setBoldStrength(int);

	int					getDPI(void) const;
	int					getPTSize(void) const;
	int					getCharSkip(void) const;
	int					getLineSkip(void) const;
	int					getSpaceLineSkip(void) const;
	bool				getSmoothFlg(void) const;
	bool				getSmoothMode(void) const;
	fk_Color			getForeColor(void) const;
	fk_Color			getBackColor(void) const;
	fk_Color			getShadowColor(void) const;
	fk_TextAlign		getAlign(void) const;
	int					getUpOffset(void) const;
	int					getDownOffset(void) const;
	int					getLeftOffset(void) const;
	int					getRightOffset(void) const;
	int					getMinLineWidth(void) const;
	int					getMaxLineWidth(void) const;
	int					getMaxLineHeight(void) const;
	int					getLineNum(void) const;
	int					getLineCharNum(int) const;
	int					getAllCharNum(void) const;
	int					getLineWidth(int) const;
	int					getLineHeight(int) const;
	int					getLineStartXPos(int) const;
	int					getLineStartYPos(int) const;
	fk_TextSendingMode	getSendingMode(void) const;
	bool				getShadowMode(void) const;
	fk_Dimension		getShadowOffset(void) const;
	int					getBoldStrength(void) const;

	static void			setCacheMode(bool);
	static bool			getCacheMode(void);
	static void			clearCache(void);
};

#endif // !__FK_TEXTIMAGE_HEADER__
