/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_GEN_VECTOR_HEADER__
#define __FK_GEN_VECTOR_HEADER__

#include <FK/Vector.h>

class fk_GenMatrix;

class fk_GenVector {

	friend class		fk_GenMatrix;

 private:

	std::vector<double>		v;

 public:

	/////// コンストラクタ群
	// 次数設定 (デフォルト)
	fk_GenVector(int = 0);
	
	// vector(STL) からの入力
	fk_GenVector(std::vector<double> &);
	
	// 次数と double 型配列
	fk_GenVector(int, double *);
	
	// コピーコンストラクタ
	fk_GenVector(const fk_GenVector &);
	
	// fk_Vector からのコピーコンストラクタ
	fk_GenVector(const fk_Vector &);
	
	// fk_HVector からのコピーコンストラクタ
	fk_GenVector(const fk_HVector &);

	//////// 演算子群
	// 単項マイナス演算子
	fk_GenVector &	operator -(void) const;

	// 同値比較演算子
	bool			operator ==(const fk_GenVector &) const;

	// 異値比較演算子
	bool			operator !=(const fk_GenVector &) const;

	// 代入演算子 
	fk_GenVector &	operator =(const fk_GenVector &);	// 代入
	fk_GenVector &	operator =(const fk_Vector &);		// 代入
	fk_GenVector &	operator =(const fk_HVector &);		// 代入
	fk_GenVector &	operator *=(double);				// 実数積
	fk_GenVector &	operator /=(double);				// 実数商
	fk_GenVector &	operator +=(const fk_GenVector &);	// 単項和
	fk_GenVector &	operator -=(const fk_GenVector &);	// 単項差
	fk_GenVector &	operator *=(const fk_GenMatrix &);	// 行列変換

	
	//////// メンバ関数群
	void			resize(int);					// 次数設定
	bool			set(int, double);				// 値のセット
	int				size(void) const;				// サイズ出力
	double			get(int) const;					// 値取得
	double			norm(void) const;				// ノルム出力
	double			norm2(void) const;				// ノルム平方出力
	bool			normalize(void);				// 正規化
	void			init(bool = false);				// 初期化
	bool			isZero(void) const;				// 零ベクトル判定
	bool			replace(int, fk_GenVector &);	// 部分置換
	bool			replace(int, fk_Vector &);		// 部分置換
	bool			replace(int, fk_HVector &);		// 部分置換
	bool			add(int, fk_GenVector &);		// 部分加算
	bool			add(int, fk_Vector &);			// 部分加算
	bool			add(int, fk_HVector &);			// 部分加算
	bool			sub(int, fk_GenVector &);		// 部分引算
	bool			sub(int, fk_Vector &);			// 部分引算
	bool			sub(int, fk_HVector &);			// 部分引算
	fk_GenVector	div(int, int);					// 部分抽出

	void			Print(void) const;				// 標準出力
	void			Print(std::string) const;		// 標準出力

	///// friend 演算子群
	// 内積演算子
	friend double		operator *(const fk_GenVector &, const fk_GenVector &);

	// 和演算子
	friend fk_GenVector	operator +(const fk_GenVector &, const fk_GenVector &);

	// 差演算子
	friend fk_GenVector	operator -(const fk_GenVector &, const fk_GenVector &);

	// 実数倍演算子
	friend fk_GenVector	operator *(const fk_GenVector &, double);

	// 実数倍演算子
	friend fk_GenVector	operator *(double, const fk_GenVector &);

	// 実数商演算子
	friend fk_GenVector	operator /(const fk_GenVector &, double);

	// 外積演算子
	friend fk_GenVector	operator ^(const fk_GenVector &, const fk_GenVector &);
};

//////// 二項演算子の外部関数宣言 
	
// 内積演算子 
double			operator *(const fk_GenVector &, const fk_GenVector &);

// 和演算子 
fk_GenVector	operator +(const fk_GenVector &, const fk_GenVector &);

// 差演算子 
fk_GenVector	operator -(const fk_GenVector &, const fk_GenVector &);

// 実数倍演算子 
fk_GenVector	operator *(const fk_GenVector &, double);

// 実数倍演算子 
fk_GenVector	operator *(double, const fk_GenVector &);

// 実数商演算子 
fk_GenVector	operator /(const fk_GenVector &, double);

// 外積演算子 
fk_GenVector	operator ^(const fk_GenVector &, const fk_GenVector &);

#endif // !__FK_GEN_VECTOR_HEADER__
