/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_REFERENCE_HEADER__
#define __FK_REFERENCE_HEADER__

#include <FK/Edge.h>

class fk_Vertex;
class fk_Half;
class fk_Loop;
class fk_Shell;

#include <vector>

/*
   ここで定義する参照関数 ---

   頂点に関連する関数
	- fk_Half * getOneHOnV(fk_Vertex *)
	- vector<fk_Half *> getAllHOnV(fk_Vertex *)
	- vector<fk_Edge *> getEOnVV(fk_Vertex *, fk_Vertex *)
	- fk_Edge * getOneEOnV(fk_Vertex *)
	- vector<fk_Edge *> getAllEOnV(fk_Vertex *)
    - int getENumOnV(fk_Vertex *)
	- fk_Loop * getOneLOnV(fk_Vertex *)
	- vector<fk_Loop *> getAllLOnV(fk_Vertex *)
	- vector<fk_Vertex *> getAllNeighborVOnV(fk_Vertex *)

   半稜線に関連する関数
	- fk_Vertex * getVOnH(fk_Half *)
	- fk_Half * getMateHOnH(fk_Half *)
	- fk_Edge * getParentEOnH(fk_Half *)
	- fk_Loop * getParentLOnH(fk_Half *)

   稜線に関連する関数
	- fk_Vertex * getRightVOnE(fk_Edge *)
	- fk_Vertex * getLeftVOnE(fk_Edge *)
	- fk_Half * getRightHOnE(fk_Edge *)
	- fk_Half * getLeftHOnE(fk_Edge *)
	- fk_Loop * getRightLOnE(fk_Edge *)
	- fk_Loop * getLeftLOnE(fk_Edge *)
	- fk_EdgeStatus getEdgeStatus(fk_Edge *)

   ループに関連する関数
	- fk_Vertex * getOneVonL(fk_Loop *)
	- vector<fk_Vertex *> getAllVOnL(fk_Loop *)
    - int getVNumOnL(fk_Loop *)
	- fk_Half * getOneHOnL(fk_Loop *)
	- vector<fk_Half *> getAllHOnL(fk_Loop *)
	- fk_Edge * getOneEOnL(fk_Loop *)
	- vector<fk_Edge *> getAllEOnL(fk_Loop *)
	- fk_Loop * getOneNeighorLOnL(fk_Loop *)
	- vector<fk_Loop *> getAllNeighborLOnL(fk_Loop *)
	- fk_Loop * getNeighborLOnLH(fk_Loop *, fk_Half *)
	- fk_Loop * getNeighborLOnLE(fk_Loop *, fk_Edge *)

*/

class fk_ReferenceL1 {
  public:

	fk_Half *		getOneHOnV(fk_Vertex *) const;
	fk_Edge *		getOneEOnV(fk_Vertex *) const;

	fk_Vertex *		getVOnH(fk_Half *) const;
	fk_Half *		getMateHOnH(fk_Half *) const;
	fk_Edge *		getParentEOnH(fk_Half *) const;
	fk_Loop *		getParentLOnH(fk_Half *) const;
	
	fk_Vertex *		getRightVOnE(fk_Edge *) const;
	fk_Vertex *		getLeftVOnE(fk_Edge *) const;
	fk_Half *		getRightHOnE(fk_Edge *) const;
	fk_Half *		getLeftHOnE(fk_Edge *) const;
	fk_Loop *		getRightLOnE(fk_Edge *) const;
	fk_Loop *		getLeftLOnE(fk_Edge *) const;
	fk_EdgeStatus	getEdgeStatus(fk_Edge *) const;
	
	fk_Vertex *		getOneVOnL(fk_Loop *) const;
	fk_Half *		getOneHOnL(fk_Loop *) const;
	fk_Edge *		getOneEOnL(fk_Loop *) const;

};

class fk_ReferenceL2 : public fk_ReferenceL1 {
  public:

	fk_Vertex *					getOneNeighborVOnV(fk_Vertex *) const;
	std::vector<fk_Half *>		getAllHOnV(fk_Vertex *) const;
	std::vector<fk_Edge *>		getAllEOnV(fk_Vertex *) const;
	std::vector<fk_Loop *>		getAllLOnV(fk_Vertex *) const;

	std::vector<fk_Vertex *>	getAllVOnL(fk_Loop *) const;
	std::vector<fk_Half *>		getAllHOnL(fk_Loop *) const;
	std::vector<fk_Edge *>		getAllEOnL(fk_Loop *) const;

	fk_Loop *					getOneNeighborLOnL(fk_Loop *) const;
	fk_Loop *					getNeighborLOnLH(fk_Loop *, fk_Half *) const;
	int							getENumOnV(fk_Vertex *) const;
	int							getVNumOnL(fk_Loop *) const;
};

class fk_ReferenceL3 : public fk_ReferenceL2 {
  public:

	std::vector<fk_Edge *>		getEOnVV(fk_Vertex *, fk_Vertex *) const;
	fk_Loop *					getOneLOnV(fk_Vertex *) const;
	fk_Loop *					getNeighborLOnLE(fk_Loop *, fk_Edge *) const;
	std::vector<fk_Loop *>		getAllNeighborLOnL(fk_Loop *) const;
	std::vector<fk_Vertex *>	getAllNeighborVOnV(fk_Vertex *) const;
};

#endif // !__FK_REFERENCE_HEADER__
