/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef	__FK_TEXTURE_HEADER__
#define	__FK_TEXTURE_HEADER__

#include <FK/Shape.h>
#include <FK/Image.h>
#include <FK/IndexFace.h>

class fk_MQOParser;
class fk_IndexFaceSet;

enum fk_TexMode {
	FK_TEX_REPLACE,
	FK_TEX_MODULATE
};

enum fk_TexRendMode {
	FK_TEX_REND_NORMAL,
	FK_TEX_REND_SMOOTH
};

class fk_TexCoord {
 public:
	float	x, y;

	fk_TexCoord(double = 0.0, double = 0.0);
	fk_TexCoord(const fk_TexCoord &);
	fk_TexCoord & operator =(const fk_TexCoord &);

	bool	operator ==(const fk_TexCoord &) const;
	void	set(double, double);
};

class fk_Texture: public fk_Shape {
	friend class		fk_TextureDraw;

 private:
	fk_Image			*image;
	fk_Image			localImage;
	fk_TexMode			texMode;
	fk_TexRendMode		texRendMode;
	fk_Palette			localPal;

	bool				GetInitFlag(void);
	void				SetInitFlag(bool);
	fk_TexID			GetTexID(void);
	void				SetTexID(const fk_TexID);

 protected:

	void				BaseInit(void);

 public:
	fk_Texture(fk_Image * = (fk_Image *)NULL);
	~fk_Texture();

	virtual void			init(void) = 0;
	void					setImage(fk_Image *);
	fk_Image *				getImage(void);
	bool					readBMP(std::string);
	bool					readBMPData(fk_ImType *);
	bool					readPNG(std::string);
	bool					readPNGData(fk_ImType *);
	const fk_Dimension *	getImageSize(void);
	const fk_Dimension *	getBufferSize(void);

	void					setTextureMode(fk_TexMode);
	fk_TexMode				getTextureMode(void);
	void					setTexRendMode(fk_TexRendMode);
	fk_TexRendMode			getTexRendMode(void);

	// 画像バッファ全体の同一色設定
	void					fillColor(const fk_Color &);
	void					fillColor(int, int, int, int = 0);

	const fk_ImType *		getImageBuf(void);
};

class fk_RectTexture : public fk_Texture {

	friend class		fk_TextureDraw;

 private:

	fk_TexCoord			texSize;
	bool				repeatFlag;
	fk_TexCoord			repeatParam;
	fk_TexCoord			texCoord[2];

 public:
	fk_RectTexture(fk_Image * = (fk_Image *)NULL);
	~fk_RectTexture();

	void				init(void);
	bool				setTextureSize(double, double);
	fk_TexCoord			getTextureSize(void);
	void				setRepeatMode(bool);
	bool				getRepeatMode(void);
	void				setRepeatParam(double, double);
	fk_TexCoord			getRepeatParam(void);
	void				setTextureCoord(double, double, double, double);
	void				setTextureCoord(const fk_TexCoord &,
										const fk_TexCoord &);
	fk_TexCoord			getTextureCoord(int);
};

class fk_TriTexture : public fk_Texture {

	friend class		fk_TextureDraw;

 private:
	fk_Vector			pos[3];
	fk_TexCoord			texCoord[3];

	fk_Vector *			getPos(void);
	fk_TexCoord *		getCoord(void);

 public:
	fk_TriTexture(fk_Image * = (fk_Image *)NULL);
	~fk_TriTexture();
	void				init(void);

	bool				setVertexPos(int, double, double, double);
	bool				setVertexPos(int, fk_Vector);
	bool				setTextureCoord(int, double, double);
	bool				setTextureCoord(int, fk_TexCoord);

	fk_Vector			getVertexPos(int);
	fk_TexCoord			getTextureCoord(int);
};

class fk_MeshTexture : public fk_Texture {

	friend class			fk_TextureDraw;

 private:

	int							triNum;
	std::vector<fk_Vector>		posArray;
	std::vector<fk_TexCoord>	coordArray;

	std::vector<fk_Vector> *	getPos(void);
	std::vector<fk_TexCoord> *	getCoord(void);

 public:
	fk_MeshTexture(fk_Image * = (fk_Image *)NULL);
	~fk_MeshTexture();
	void			init(void);

	bool			setTriNum(int);
	bool			setVertexPos(int, int, double, double, double);
	bool			setVertexPos(int, int, fk_Vector);
	bool			setTriPos(int, std::vector<fk_Vector> *);
	bool			setTriPos(int, fk_Vector *);
	bool			setTextureCoord(int, int, double, double);
	bool			setTextureCoord(int, int, fk_TexCoord);
	bool			setTriTextureCoord(int, std::vector<fk_TexCoord> *);
	bool			setTriTextureCoord(int, fk_TexCoord *);

	int				getTriNum(void);
	fk_Vector		getVertexPos(int, int);
	fk_TexCoord		getTextureCoord(int, int);

	void			putIndexFaceSet(fk_IndexFaceSet *);

	bool			readMQOFile(std::string, std::string, bool = true);
};

#endif	// !__FK_TEXTURE_HEADER__
