/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <FK/Base.h>
#include <FK/DXFOut.h>
#include <FK/Solid.h>
#include <FK/IndexFace.h>
#include <FK/Vertex.h>
#include <FK/Loop.h>

using namespace std;

fk_DXFOut::fk_DXFOut(fk_Solid *argSolid)
{
	solid = argSolid;
	ifs = (fk_IndexFaceSet *)NULL;

	return;
}

fk_DXFOut::fk_DXFOut(fk_IndexFaceSet *argIFS)
{
	ifs = argIFS;
	solid = (fk_Solid *)NULL;

	return;
}

fk_DXFOut::~fk_DXFOut()
{
	return;
}

bool fk_DXFOut::writeDXFFile(string argFileName, bool argTriFlg)
{
	FILE		*writeFP;
	bool		retFlg;

	if(solid == (fk_Solid *)NULL && ifs == (fk_IndexFaceSet *)NULL) return false;

	if((writeFP = fopen(argFileName.c_str(), "w")) == (FILE *)NULL) {
		return false;
	}

	if(solid != (fk_Solid *)NULL) {
		retFlg = WriteDXFShape_Solid(writeFP, argTriFlg);
	} else {
		retFlg = WriteDXFShape_IFS(writeFP, argTriFlg);
	}

	fclose(writeFP);

	return retFlg;
}

bool fk_DXFOut::WriteDXFShape_Solid(FILE *argFP, bool argTriFlg)
{
	fk_Loop							*curL;
	vector<fk_Vertex *>				vArray;
	vector<fk_Vertex *>::size_type	i;
	fk_Vector						pos;

	fprintf(argFP, " 0\n");
	fprintf(argFP, "SECTION\n");
	fprintf(argFP, " 2\n");
	fprintf(argFP, "ENTITIES\n");
	fprintf(argFP, " 999\n");
	fprintf(argFP, "Created By FineKernel ToolKit\n");

	for(curL = solid->getNextL((fk_Loop *)NULL);
		curL != (fk_Loop *)NULL; curL = solid->getNextL(curL)) {

		vArray = solid->getAllVOnL(curL);
		if(vArray.size() != 3 && vArray.size() != 4) return false;

		fprintf(argFP, " 0\n");
		fprintf(argFP, "3DFACE\n");
		fprintf(argFP, " 8\n");
		fprintf(argFP, "layer1\n");

		for(i = 0; i < vArray.size(); i++) {
			pos = vArray[i]->getPosition();
			fprintf(argFP, " 1%d\n", int(i));
			fprintf(argFP, "%f\n", pos.x);
			fprintf(argFP, " 2%d\n", int(i));
			fprintf(argFP, "%f\n", pos.y);
			fprintf(argFP, " 3%d\n", int(i));
			fprintf(argFP, "%f\n", pos.z);
		}

		if(vArray.size() == 3 && argTriFlg == false) {
			fprintf(argFP, " 13\n");
			fprintf(argFP, "%f\n", pos.x);
			fprintf(argFP, " 23\n");
			fprintf(argFP, "%f\n", pos.y);
			fprintf(argFP, " 33\n");
			fprintf(argFP, "%f\n", pos.z);
		}

	}

	fprintf(argFP, " 0\n");
	fprintf(argFP, "ENDSEC\n");
	fprintf(argFP, " 0\n");
	fprintf(argFP, "EOF\n");

	return true;
}

bool fk_DXFOut::WriteDXFShape_IFS(FILE *argFP, bool argTriFlg)
{
	vector<int>			fData;
	fk_Vector			pos;
	int					i, j;

	fprintf(argFP, " 0\n");
	fprintf(argFP, "SECTION\n");
	fprintf(argFP, " 2\n");
	fprintf(argFP, "ENTITIES\n");
	fprintf(argFP, " 999\n");
	fprintf(argFP, "Created By FineKernel ToolKit\n");

	for(i = 0; i < ifs->getFaceSize(); i++) {
		fData = ifs->getFaceData(i);

		fprintf(argFP, " 0\n");
		fprintf(argFP, "3DFACE\n");
		fprintf(argFP, " 8\n");
		fprintf(argFP, "layer1\n");

		for(j = 0; j < int(fData.size()); j++) {
			pos = ifs->getPosVec(fData[j]);
			fprintf(argFP, " 1%d\n", int(i));
			fprintf(argFP, "%f\n", pos.x);
			fprintf(argFP, " 2%d\n", int(i));
			fprintf(argFP, "%f\n", pos.y);
			fprintf(argFP, " 3%d\n", int(i));
			fprintf(argFP, "%f\n", pos.z);
		}

		if(fData.size() == 3 && argTriFlg == false) {
			fprintf(argFP, " 13\n");
			fprintf(argFP, "%f\n", pos.x);
			fprintf(argFP, " 23\n");
			fprintf(argFP, "%f\n", pos.y);
			fprintf(argFP, " 33\n");
			fprintf(argFP, "%f\n", pos.z);
		}
	}

	fprintf(argFP, " 0\n");
	fprintf(argFP, "ENDSEC\n");
	fprintf(argFP, " 0\n");
	fprintf(argFP, "EOF\n");

	return true;
}
