/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2009, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <FK/DXFParser.h>

using namespace std;

fk_DXFParser::fk_DXFParser(void)
{
	return;
}

fk_DXFParser::~fk_DXFParser()
{
	return;
}

bool fk_DXFParser::readDXFFile(string argFileName, bool argSolidFlg)
{
	FILE					*fp;
	vector<fk_Vector>		vecSet;
	vector< vector<int> >	IFSet;

	if(meshData == (fk_ParserData *)NULL) return false;

	if((fp = fopen(argFileName.c_str(), "r")) == (FILE *)NULL) {
		return false;
	}

	if(CheckDXFFile(fp) == false) {
		fclose(fp);
		return false;
	}

	fseek(fp, 0L, 0);

	if(MakeDXFIFSet(fp, &vecSet, &IFSet, argSolidFlg) == false) {
		fclose(fp);
		return false;
	}

	fclose(fp);

	meshData->Init();

	return meshData->MakeMesh(&vecSet, &IFSet,
							  (vector<int> *)NULL, argSolidFlg);
}

bool fk_DXFParser::CheckDXFFile(FILE *argFP)
{
	char	buffer[512];
	string	lineStr, word;
	char	*eofStatus;
	bool	faceFlg;

	faceFlg = false;
	eofStatus = fgets(buffer, 511, argFP);
	while(feof(argFP) == 0 && eofStatus != (char *)NULL) {
		lineStr = buffer;
		StringToLower(&lineStr);
		if(faceFlg == true) {
			if(SearchWord(&lineStr, "10") != string::npos) {
				eofStatus = fgets(buffer, 511, argFP);
				eofStatus = fgets(buffer, 511, argFP);
				lineStr = buffer;
				if(SearchWord(&lineStr, "20") == string::npos) {
					return false;
				}
				eofStatus = fgets(buffer, 511, argFP);
				eofStatus = fgets(buffer, 511, argFP);
				lineStr = buffer;
				if(SearchWord(&lineStr, "30") == string::npos) {
					return false;
				}
				return true;
			}
		}

		if(SearchWord(&lineStr, "3dface") != string::npos) {
			faceFlg = true;
		}

		eofStatus = fgets(buffer, 511, argFP);
	}


	return false;
}

bool fk_DXFParser::MakeDXFIFSet(FILE *argFP, vector<fk_Vector> *argVecSet,
								vector< vector<int> > *argIFSet,
								bool argSolidFlg)
{
	char					buffer[512];
	string					lineStr, valStr;
	bool					loopFlg;
	fk_Vector				tmpVec[4];
	char					*eofStatus;
	bool					sqFlg;
	fk_HeapBase<fk_Vector>	heap;


	loopFlg = false;
	sqFlg = false;

	eofStatus = fgets(buffer, 511, argFP);

	while(feof(argFP) == 0 && eofStatus != (char *)NULL) {
		lineStr = buffer;
		StringToLower(&lineStr);

		if(loopFlg == true) {

			if(SearchWord(&lineStr, "0") != string::npos) {
				loopFlg = false;
				MakeLoop(argVecSet, argIFSet, argSolidFlg, tmpVec, sqFlg,
						 &heap);
				eofStatus = fgets(buffer, 511, argFP);
				sqFlg = false;
				continue;
			}

			eofStatus = fgets(buffer, 511, argFP);
			valStr = buffer;

			if(SetPosVal(tmpVec, &lineStr, &valStr) == true) {
				sqFlg = true;
			}
		}

		if(loopFlg == false) {
			if(SearchWord(&lineStr, "3dface") != string::npos) {
				loopFlg = true;
				sqFlg = false;
			}
		}

		eofStatus = fgets(buffer, 511, argFP);
	}
	return true;
}

bool fk_DXFParser::SetPosVal(fk_Vector *argPos,
							 string *argLine, string *argValLine)
{
	bool retFlg;

	retFlg = false;

	if(SearchWord(argLine, "10") != string::npos) {
		argPos[0].x = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "20") != string::npos) {
		argPos[0].y = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "30") != string::npos) {
		argPos[0].z = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "11") != string::npos) {
		argPos[1].x = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "21") != string::npos) {
		argPos[1].y = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "31") != string::npos) {
		argPos[1].z = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "12") != string::npos) {
		argPos[2].x = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "22") != string::npos) {
		argPos[2].y = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "32") != string::npos) {
		argPos[2].z = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "13") != string::npos) {
		retFlg = true;
		argPos[3].x = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "23") != string::npos) {
		retFlg = true;
		argPos[3].y = Str2Double(PopWord(argValLine));
	} else if(SearchWord(argLine, "33") != string::npos) {
		retFlg = true;
		argPos[3].z = Str2Double(PopWord(argValLine));
	}

	return retFlg;
}

int fk_DXFParser::GetLoopSize(fk_Vector *argPos, bool argFlg)
{
	if(argFlg == false) {
		return 3;
	}

	if(argPos[2] == argPos[3]) {
		return 3;
	}

	return 4;
}

void fk_DXFParser::MakeLoop(vector<fk_Vector> *argVecSet,
							vector< vector<int> > *argIFSet, bool argSolidFlg,
							fk_Vector *argTmpVec, bool argSqFlg,
							fk_HeapBase<fk_Vector> *argHeap)
{
	vector<int>		VIDSet;
	int				loopSize, vecSize, i;
	bool			vecFlg;
	int				index;

	loopSize = GetLoopSize(argTmpVec, argSqFlg);
	VIDSet.clear();

	for(i = 0; i < loopSize; i++) {

		vecFlg = false;
		if(argSolidFlg == true) {
			vecSize = int(argVecSet->size());

			index = argHeap->getID(&argTmpVec[i]);

			if(index != vecSize+1) {
				VIDSet.push_back(index);
				vecFlg = true;
			}
		}

		if(vecFlg == false) {
			vecSize = int(argVecSet->size());
			argVecSet->push_back(argTmpVec[i]);
			VIDSet.push_back(vecSize+1);
		}
	}

	argIFSet->push_back(VIDSet);

	return;
}
