/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __TINY_FK_WINDOW_HEADER__
#define __TINY_FK_WINDOW_HEADER__

#include <FK/FK.h>

class TFK_BaseSet;
class TFK_WindowBase;

typedef fk_SpecialKey TFK_SpecialKey;

const TFK_SpecialKey TFK_SHIFT_R = FK_SHIFT_R;
const TFK_SpecialKey TFK_SHIFT_L = FK_SHIFT_L;
const TFK_SpecialKey TFK_CTRL_R = FK_CTRL_R;
const TFK_SpecialKey TFK_CTRL_L = FK_CTRL_L;
const TFK_SpecialKey TFK_ALT_R = FK_ALT_R;
const TFK_SpecialKey TFK_ALT_L = FK_ALT_L;
const TFK_SpecialKey TFK_ENTER = FK_ENTER;
const TFK_SpecialKey TFK_BACKSPACE = FK_BACKSPACE;
const TFK_SpecialKey TFK_DELETE = FK_DELETE;
const TFK_SpecialKey TFK_CAPS_LOCK = FK_CAPS_LOCK;
const TFK_SpecialKey TFK_TAB = FK_TAB;
const TFK_SpecialKey TFK_PAGE_UP = FK_PAGE_UP;
const TFK_SpecialKey TFK_PAGE_DOWN = FK_PAGE_DOWN;
const TFK_SpecialKey TFK_HOME = FK_HOME;
const TFK_SpecialKey TFK_END = FK_END;
const TFK_SpecialKey TFK_INSERT = FK_INSERT;
const TFK_SpecialKey TFK_LEFT = FK_LEFT;
const TFK_SpecialKey TFK_RIGHT = FK_RIGHT;
const TFK_SpecialKey TFK_UP = FK_UP;
const TFK_SpecialKey TFK_DOWN = FK_DOWN;
const TFK_SpecialKey TFK_F1 = FK_F1;
const TFK_SpecialKey TFK_F2 = FK_F2;
const TFK_SpecialKey TFK_F3 = FK_F3;
const TFK_SpecialKey TFK_F4 = FK_F4;
const TFK_SpecialKey TFK_F5 = FK_F5;
const TFK_SpecialKey TFK_F6 = FK_F6;
const TFK_SpecialKey TFK_F7 = FK_F7;
const TFK_SpecialKey TFK_F8 = FK_F8;
const TFK_SpecialKey TFK_F9 = FK_F9;
const TFK_SpecialKey TFK_F10 = FK_F10;
const TFK_SpecialKey TFK_F11 = FK_F11;
const TFK_SpecialKey TFK_F12 = FK_F12;

class TFK_Window {
 private:

	TFK_BaseSet		*base;
	TFK_WindowBase	*winBase;

 public:
	TFK_Window(void);
	TFK_Window(const TFK_Window &);
	~TFK_Window();
	TFK_Window & operator =(const TFK_Window &);

	void		setBaseSize(int, int);
	void		setCanvas(int, int, int, int);
	void		open(void);
	void		draw(void);
	bool		wait(void);
	bool		wait(double);
	bool		check(void);
	void		sleep(double);
	void		setBGColor(double, double, double);
	void		setBlendMode(bool);
	bool		getBlendMode(void);
	void		setESCExitMode(bool);

	void		clearAllPoint(void);
	void		clearAllLine(void);
	void		clearAllPolygon(void);
	void		clearAllBlock(void);
	void		clearAllSphere(void);
	void		clearAllPrism(void);
	void		clearAllCone(void);
	void		clearAllLight(void);
	void		clearAllMesh(void);
	void		clearAllTexture(void);

	void		setAllPointPalette(int);
	void		setAllLinePalette(int);
	void		setAllPolygonPalette(int);
	void		setDefaultPointPalette(int);
	void		setDefaultLinePalette(int);
	void		setDefaultPolygonPalette(int);

	void		setAllPointSize(double);
	void		setAllLineWidth(double);
	void		setDefaultPointSize(double);
	void		setDefaultLineWidth(double);

	void		setPlaneMode(bool);
	bool		getPlaneMode(void);

	bool		getMouseStatus(int);
	fk_Vector	getMousePosition(void);
	fk_Vector	waitMouse(int);
	bool		getKeyStatus(char);
	bool		getSpecialKeyStatus(TFK_SpecialKey);

	void		makeButton(int, int, int, int, int, int, std::string);
	bool		getButtonStatus(int);
	void		setButtonStatus(int, bool);
	void		makeTextBox(int, int, int, int, int, std::string);
	std::string	getTextBoxString(int);
	void		setTextBoxString(int, std::string);

	void		makeGroup(int, int, int, int, int);
	void		entryButton(int, int);
	void		entryTextBox(int, int);

	std::string	fileChooser(int);
	fk_Color	colorChooser(void);
	fk_Color	colorChooser(fk_Color);

	void		put(const char *, ...);
	void		put(std::string);
	void		openPutWindow(int, int);
	void		closePutWindow(void);
	void		clearPutWindow(void);

	bool		snap(std::string);

	bool		save(std::string, bool = false);
	bool		load(std::string, bool = false);

	void		message(std::string);
	void		alert(std::string);
	bool		ask(std::string);
};

#endif // !__TINY_FK_WINDOW_HEADER__
