/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include "TFK_BaseSet.h"

using namespace std;

const double	ONE_FRAME_TIME = 0.001;

TFK_BaseSet::TFK_BaseSet(void)
{
	fk_Perspective		proj(2.0*FK_PI/9.0, 1.0, 6000.0);
	fk_Palette			*palette;

	pointBase = new TFK_PointBase();
	lineBase = new TFK_LineBase();
	polyBase = new TFK_PolygonBase();
	blockBase = new TFK_BlockBase();
	sphereBase = new TFK_SphereBase();
	prismBase = new TFK_PrismBase();
	coneBase = new TFK_ConeBase();
	fileBase = new TFK_FileDataBase();
	meshBase = new TFK_MeshBase();
	textureBase = new TFK_TextureBase();
	lightBase = new TFK_LightBase();
	paletteBase = new TFK_PaletteBase();
	winBase = new TFK_WindowBase();

	camera = new fk_Model();
	camera->glMoveTo(0.0, 0.0, TFK_COORD_SIZE/tan(FK_PI/9.0));
	camera->glVec(0.0, 0.0, -1.0);
	camera->glUpvec(0.0, 1.0, 0.0);

	scene = new fk_Scene();
	scene->setProjection(&proj);

	pointBase->setScene(scene);
	lineBase->setScene(scene);
	polyBase->setScene(scene);
	blockBase->setScene(scene);
	sphereBase->setScene(scene);
	prismBase->setScene(scene);
	coneBase->setScene(scene);
	fileBase->setScene(scene);
	meshBase->setScene(scene);
	textureBase->setScene(scene);
	lightBase->setScene(scene);
	winBase->setScene(scene);

	palette = paletteBase->getPalette();
	pointBase->setPalette(palette);
	lineBase->setPalette(palette);
	polyBase->setPalette(palette);
	blockBase->setPalette(palette);
	sphereBase->setPalette(palette);
	prismBase->setPalette(palette);
	coneBase->setPalette(palette);
	fileBase->setPalette(palette);
	meshBase->setPalette(palette);
	textureBase->setPalette(palette);
	lightBase->setPalette(palette);

	scene->entryCamera(camera);
	scene->setBGColor(1.0, 1.0, 1.0);
	scene->setBlendStatus(true);

	planeMode = false;

	return;
}

TFK_BaseSet::~TFK_BaseSet()
{
	delete camera;
	delete scene;

	delete pointBase;
	delete lineBase;
	delete polyBase;
	delete blockBase;
	delete sphereBase;
	delete prismBase;
	delete coneBase;
	delete fileBase;
	delete meshBase;
	delete textureBase;
	delete lightBase;
	delete paletteBase;
	delete winBase;

	return;
}

TFK_PointBase * TFK_BaseSet::getPointBase(void)
{
	return pointBase;
}

TFK_LineBase * TFK_BaseSet::getLineBase(void)
{
	return lineBase;
}

TFK_PolygonBase * TFK_BaseSet::getPolygonBase(void)
{
	return polyBase;
}

TFK_BlockBase * TFK_BaseSet::getBlockBase(void)
{
	return blockBase;
}

TFK_SphereBase * TFK_BaseSet::getSphereBase(void)
{
	return sphereBase;
}

TFK_PrismBase * TFK_BaseSet::getPrismBase(void)
{
	return prismBase;
}

TFK_ConeBase * TFK_BaseSet::getConeBase(void)
{
	return coneBase;
}

TFK_FileDataBase * TFK_BaseSet::getFileDataBase(void)
{
	return fileBase;
}

TFK_MeshBase * TFK_BaseSet::getMeshBase(void)
{
	return meshBase;
}

TFK_TextureBase * TFK_BaseSet::getTextureBase(void)
{
	return textureBase;
}

TFK_LightBase * TFK_BaseSet::getLightBase(void)
{
	return lightBase;
}

TFK_PaletteBase * TFK_BaseSet::getPaletteBase(void)
{
	return paletteBase;
}

TFK_WindowBase * TFK_BaseSet::getWindowBase(void)
{
	return winBase;
}

fk_Model * TFK_BaseSet::getCamera(void)
{
	return camera;
}

void TFK_BaseSet::setBGColor(double argR, double argG, double argB)
{
	scene->setBGColor(float(argR), float(argG), float(argB));
	return;
}

/////////////////////////////////////////////////////////////////////

void TFK_BaseSet::VerWrite(FILE *argFP, fk_DataFormatMode argMode)
{
	int	cur = TFK_FILE_MAJOR*10000 + TFK_FILE_MINOR*100 + TFK_FILE_SUBMINOR;
	int mask = TFK_FILE_MASK;
	
	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "TFKMASK = %d\n", TFK_FILE_MASK);
		fprintf(argFP, "FILEVER = %d\n", cur);
		break;

	  case FK_BINARY_FILE:
		bWrite(&mask, 1, argFP);
		bWrite(&cur, 1, argFP);
		break;

	  default:
		break;
	}
	return;
}

int TFK_BaseSet::VerRead(FILE *argFP, fk_DataFormatMode argMode)
{
	int			mask;
	int			curVer;
	char		buffer[256], dummy[256];

	switch(argMode) {
	  case FK_TEXT_FILE:
		if(fgets(buffer, 255, argFP) == (char *)NULL) return -1;
		sscanf(buffer, "%s%s%d", dummy, dummy, &mask);
		if(fgets(buffer, 255, argFP) == (char *)NULL) return -1;
		sscanf(buffer, "%s%s%d", dummy, dummy, &curVer);
		break;

	  case FK_BINARY_FILE:
		if(bRead(&mask, 1, argFP) == false) {
			return -1;
		}

		if(bRead(&curVer, 1, argFP) == false) {
			return -1;
		}
		break;

	  default:
		return -1;
	}
	
	if(mask != TFK_FILE_MASK) return -1;

	return curVer;
}

void TFK_BaseSet::BGWrite(FILE *argFP, fk_DataFormatMode argMode)
{
	fk_Color		col = scene->getBGColor();

	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "BGCOLOR = %f %f %f\n",
				col.getR(), col.getG(), col.getB());
		break;

	  case FK_BINARY_FILE:
		bWrite(col.col, 3, argFP);
		break;

	  default:
		break;
	}
	return;
}

fk_Color TFK_BaseSet::BGRead(FILE *argFP, fk_DataFormatMode argMode)
{
	fk_Color		col;
	float			r, g, b;
	char			buffer[256], dummy[256];

	switch(argMode) {
	  case FK_TEXT_FILE:
		if(fgets(buffer, 255, argFP) == (char *)NULL) return col;
		sscanf(buffer, "%s%s%f%f%f", dummy, dummy, &r, &g, &b);
		col.set(r, g, b);
		break;

	  case FK_BINARY_FILE:
		bRead(col.col, 3, argFP);
		break;

	  default:
		break;
	}

	return col;
}

bool TFK_BaseSet::saveFile(string argFile, fk_DataFormatMode argMode)
{
	FILE		*fp;

	switch(argMode) {
	  case FK_TEXT_FILE:
		if((fp = fopen(argFile.c_str(), "w")) == (FILE *)NULL) {
			return false;
		}
		break;

	  case FK_BINARY_FILE:
		if((fp = fopen(argFile.c_str(), "wb")) == (FILE *)NULL) {
			return false;
		}
		break;

	  default:
		return false;
	}

	VerWrite(fp, argMode);

	if(pointBase->saveData(fp, argMode) == false) {
		fclose(fp);
		return false;
	}

	if(lineBase->saveData(fp, argMode) == false) {
		fclose(fp);
		return false;
	}

	if(polyBase->saveData(fp, argMode) == false) {
		fclose(fp);
		return false;
	}

	if(paletteBase->saveData(fp, argMode) == false) {
		fclose(fp);
		return false;
	}

	BGWrite(fp, argMode);

	fclose(fp);
	return true;
}

bool TFK_BaseSet::loadFile(string argFile, fk_DataFormatMode argMode)
{
	FILE		*fp;
	int			curVer;
	bool		sizeMode;

	switch(argMode) {
	  case FK_TEXT_FILE:
 		if((fp = fopen(argFile.c_str(), "r")) == (FILE *)NULL) {
			return false;
		}
		break;

	  case FK_BINARY_FILE:
		if((fp = fopen(argFile.c_str(), "rb")) == (FILE *)NULL) {
			return false;
		}
		break;

	  default:
		return false;
	}

	curVer = VerRead(fp, argMode);
	if(curVer != 10000 && curVer != 10100 && curVer != 10200) return false;
	
	if(curVer <= 10100) {
		sizeMode = false;
	} else {
		sizeMode = true;
	}

	if(pointBase->loadData(fp, argMode, sizeMode) == false) {
		fclose(fp);
		return false;
	}

	if(curVer == 10000) {
		if(paletteBase->loadData(fp, argMode) == false) {
			fclose(fp);
			return false;
		}
	}

	if(lineBase->loadData(fp, argMode, sizeMode) == false) {
		fclose(fp);
		return false;
	}

	if(curVer == 10000) {
		if(paletteBase->loadData(fp, argMode) == false) {
			fclose(fp);
			return false;
		}
	}

	if(polyBase->loadData(fp, argMode, sizeMode) == false) {
		fclose(fp);
		return false;
	}

	if(paletteBase->loadData(fp, argMode, sizeMode) == false) {
		fclose(fp);
		return false;
	}
	
	if(curVer >= 10200) {
		scene->setBGColor(BGRead(fp, argMode));
	}

	fclose(fp);
	return true;
}

void TFK_BaseSet::setPlaneMode(bool argFlg)
{
	planeMode = argFlg;

	pointBase->setPlaneMode(planeMode);
	lineBase->setPlaneMode(planeMode);
	polyBase->setPlaneMode(planeMode);

	return;
}

bool TFK_BaseSet::getPlaneMode(void)
{
	return planeMode;
}
