/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __TINY_FK_WINDOW_BASE_HEADER__
#define __TINY_FK_WINDOW_BASE_HEADER__

#include "TFK_GUIBase.h"
#include <Fl/Fl_Multi_Browser.h>
#include <Fl/Fl_File_Chooser.h>
#include <Fl/Fl_Color_Chooser.h>

const int TFK_MAX_WINSIZE = 2048;
const double TFK_COORD_SIZE = 10.0;

class TFK_WindowBase {

 private:

	Fl_Window			*baseWin;
	fk_Window			*fkWin;
	fk_Scene			*scene;

	int					baseW, baseH;
	int					fkX, fkY, fkW, fkH;
	int					drawEvent;

	TFK_GUIBase			gui;

	Fl_Window			*putWin;
	Fl_Multi_Browser	*browser;

	unsigned long		getNow(void);

 public:

	TFK_WindowBase(void);
	~TFK_WindowBase();

	void		setScene(fk_Scene *);
	void		setBaseSize(int, int);
	void		setCanvas(int, int, int, int);
	bool		openWindow(void);
	void		drawWindow(void);
	bool		waitEvent(void);
	bool		waitEvent(double);
	bool		checkEvent(void);
	void		sleepTime(double);
	void		setBlendMode(bool);
	bool		getBlendMode(void);
	bool		getMouseStatus(int);
	fk_Vector	getMousePosition(void);
	fk_Vector	waitMouse(int);
	bool		getKeyStatus(char);
	bool		getSpecialKeyStatus(fk_SpecialKey);
	void		setESCExitMode(bool);

	void		makeButton(int, int, int, int, int, int, std::string);
	bool		getButtonStatus(int);
	void		setButtonStatus(int, bool);
	void		makeTextBox(int, int, int, int, int, std::string);
	std::string	getTextBoxString(int);
	void		setTextBoxString(int, std::string);
	void		makeGroup(int, int, int, int, int);
	void		entryButton(int, int);
	void		entryTextBox(int, int);

	std::string	fileChooser(int);
	fk_Color	colorChooser(void);
	fk_Color	colorChooser(fk_Color);

	void		putString(std::string);
	void		openPutWindow(int, int);
	void		closePutWindow(void);
	void		clearPutWindow(void);

	bool		snapImage(std::string);

	void		message(std::string);
	void		alert(std::string);
	bool		ask(std::string);
};

#endif // !__TINY_FK_WINDOW_BASE_HEADER__
