#!/usr/bin/perl

my $comStart = 0;
my $extStart = 0;
my $refStart = 0;
my $verbMode = 0;
my $descStart = 0;
my $oldKey;
my $title = "";

while(<STDIN>) {
	$line = $_;
	chop $line;
	$line =~ s/^\s*//;
	@list = split(/\s/, $line);
	$oldKey = $key;
	$key = $list[0];
	shift(@list);
	$str = join(' ', @list);
	$str =~ s/\$/\\\$/g;
	$str =~ s/\#/\\\#/g;
	$str =~ s/\_/\\\_/g;
	$str =~ s/\&/\\\&/g;
	$str =~ s/\%/\\\%/g;
	$str =~ s/\^/\$\{\}\^\{\\land\}\$/g;

	if($verbMode == 1) {
		if($key eq '$VERBEND') {
			$verbMode = 0;
			print '\end{verbatim}' . "\n";
		} else {
			print $_;
		}
	} elsif($key eq '$VERBBEGIN') {
		$verbMode = 1;
		print '\begin{verbatim}' . "\n";
	} elsif($key eq '$TITLE') {
		$title = $str;
	} elsif($key eq '$VER') {
		print '\documentclass[a4j]{jarticle}' . "\n";
		print '\usepackage{ascmac}' . "\n";
		print '\usepackage{julem}' . "\n";
		print '\usepackage[dvipdfm,bookmarks=true,';
		print 'bookmarksnumbered=true,' . "\n";
		print "\t\t" . 'bookmarkstype=toc]{hyperref}' . "\n\n";
		print '\textwidth=480pt' . "\n";
		print '\textheight=660pt' . "\n";
		print '\oddsidemargin=-10pt' . "\n";
		print '\evensidemargin=-10pt' . "\n\n";
		print '\renewcommand{\labelenumi}{ \arabic{enumi} : }';
		print "\n";
		print '\begin{document}' . "\n";
		print '\begin{center}' . "\n";
		print '{\LARGE ' . $title .
			' (Ver ' . $str . ')} \\\\' . "\n";
		print '{\Large }' . "\n";
		print '\end{center}' . "\n";
	} elsif($key eq '$SEC' || $key eq '$SUBSEC') {
		if($extStart != 0) {
			print "\t" . '\end{enumerate}' . "\n";
			$extStart = 0;
		}			
		if($descStart != 0) {
			print '\end{description}' . "\n";
			$descStart = 0;
		}

		if($key eq '$SEC') {
			print '\section{' . $str . '}' . "\n";
		} else {
			print '\subsection{' . $str . '}' . "\n";
		}
		$comStart = 0;
		$refStart = 0;
		$extStart = 0;
	} elsif($key eq '$COM') {
		if($extStart != 0) {
			print "\t" . '\end{enumerate}' . "\n";
			$extStart = 0;
		}

		if($descStart == 0) {
			print '\begin{description}' . "\n";
			$descStart = 1;
		}

		if($refStart == 0) {
			print "\n";
		}

		print '\item[{\bf ' . $str . '}]';
		$extStart = 0;
		$comStart = 1;
		$refStart = 0;
	} elsif($key eq '$REF') {
		if($refStart == 0) {
			print '~ \\\\';
			print "\n";
		}
		$refStart = 1;
		print "\t" . $str . "\n";
	} elsif($key eq '$EXT') {
		if($extStart == 0) {
			print "\t" . '\begin{enumerate}' . "\n";
		}
		if($oldKey ne '$EXT') {
			print "\t" . '\item {\tt '. $str . '} \\\\' . "\n";
		} else {
			print "\t\t" . '{\tt ' . $str . '} \\\\' . "\n";
		}
		$extStart = 1;
	} elsif($key eq '$MAN') {
		print "\t\t" . $str . "\n";
	} elsif($key eq '$ITEMBEGIN') {
		print "\t\t" . '\begin{itemize}' . "\n";
	} elsif($key eq '$ITEM') {
		print "\t\t\t" . '\item ' . $str . "\n";
	} elsif($key eq '$ITEMEND') {
		print "\t\t" . '\end{itemize}' . "\n";
	}
}

if($extStart != 0) {
	print "\t" . '\end{enumerate}' . "\n";
}
print "\n" . '\end{description}'. "\n";
print '\end{document}' . "\n";
