#include <TinyFK/TinyFK.h>

int main(int, char *[])
{

#ifdef _MACOSX_
	char	*path = getenv("PWD");
	if(path == NULL) exit(1);
	if(chdir(path) != 0) exit(2);
#endif

	TFK_Window		window;
	TFK_FileData	fileData;
	TFK_Palette		pal;
	TFK_Light		light;
	TFK_Camera		camera;

	window.setBaseSize(820, 620);
	window.setCanvas(10, 10, 800, 600);

	pal.setDiffuse(1, 0.0, 1.0, 1.0);
	pal.setAmbient(1, 0.1, 0.1, 0.1);

	pal.setDiffuse(2, 1.0, 1.0, 1.0);
	pal.setAmbient(2, 1.0, 1.0, 1.0);

	fileData.readMQOFile("mqoData.mqo", "obj1");
	fileData.setPalette(1);

	light.create(1);
	light.setPalette(2);
	light.setVec(-1.0, 1.0, -1.0);

	camera.setPos(0.0, 0.0, 800.0);

	window.open();
	while(window.check() == true) {
		window.sleep(0.01);
		fileData.rotate(2, TFK_PI/200.0, true);
		window.draw();
	}

	return 0;
}
