/****************************************************************************
 *
 *	Copyright (c) 1999-2011, Fine Kernel Project, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2011, Fine Kernel Project, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include <FK/HRCParser.H>

using namespace std;

fk_HRCParser::fk_HRCParser(void)
{
	return;
}

fk_HRCParser::~fk_HRCParser()
{
	return;
}

bool fk_HRCParser::ReadHRCFile(string argFileName)
{
	FILE					*HRCFP;
	vector<fk_Vector>		VData;
	vector< vector<int> >	LIndex;

	if(meshData == NULL) return false;

	if((HRCFP = fopen(argFileName.c_str(), "r")) == NULL) {
		return false;
	}

	if(CheckHRCFile(HRCFP) == false) {
		fclose(HRCFP);
		return false;
	}

	if(ReadHRCVertexData(HRCFP, &VData) == false) {
		fclose(HRCFP);
		return false;
	}

	if(ReadHRCPolygonData(HRCFP, &LIndex) == false) {
		fclose(HRCFP);
		return false;
	}

	fclose(HRCFP);

	meshData->Init();

	return meshData->MakeMesh(&VData, &LIndex);
}

bool fk_HRCParser::CheckHRCFile(FILE *argFP)
{
	char			buffer[512];
	string			LineString;

	fgets(buffer, 511, argFP);
	LineString = buffer;

	if(LineString.find("HRCH: Softimage 4D Creative Environment") != 0) {
		return false;
	}

	return true;
}

bool fk_HRCParser::ReadHRCVertexData(FILE *argFP, vector<fk_Vector> *argVData)
{
	char		buffer[512];
	string		LineStr;
	string		CoordStr;
	bool		endFlg, VertexFlg;
	int			VtNum;
	fk_Vector	tmp;
	char *		eofStatus;

	endFlg = false;
	VtNum = 0;
	VertexFlg = false;
	eofStatus = fgets(buffer, 511, argFP);

	while(endFlg == false && feof(argFP) == 0 && eofStatus != NULL) {
		LineStr = buffer;
		if(VertexFlg == true) {
			if(LineStr.find("}") != string::npos) {
				endFlg = true;
			} else {
				CoordStr = LineStr.substr(LineStr.find("position") + 9);
				tmp.x = Str2Double(PopWord(&CoordStr));
				tmp.y = Str2Double(PopWord(&CoordStr));
				tmp.z = Str2Double(PopWord(&CoordStr));
				argVData->push_back(tmp);
			}
		}

		if(VertexFlg == false && LineStr.find("vertices") != string::npos) {
			VertexFlg = true;
			CoordStr = LineStr.substr(LineStr.find("vertices") + 8);
			VtNum = Str2Int(PopWord(&CoordStr));
			fgets(buffer, 511, argFP);
		}
		eofStatus = fgets(buffer, 511, argFP);
	}

	if(VtNum != static_cast<int>(argVData->size())) return false;
	return true;
}

bool fk_HRCParser::ReadHRCPolygonData(FILE *argFP,
									  vector< vector<int> > *argLIndex)
{
	char			buffer[512];
	string			LineStr;
	string			SubStr;
	bool			EndFlg;
	bool			IFFlg;
	int				PolyNum = 0;
	int				VtNum;
	vector<int>		PolyIndex;
	int				VID;
	char			*eofStatus;

	EndFlg = false;
	IFFlg = false;
	eofStatus = fgets(buffer, 511, argFP);
	while(EndFlg == false &&
		  feof(argFP) == 0 && eofStatus != NULL) {
		LineStr = buffer;
		if(IFFlg == true) {
			if(LineStr.find("}") != string::npos) {
				EndFlg = true;
			} else if(LineStr.find("nodes") != string::npos) {
				SubStr = LineStr.substr(LineStr.find("nodes") + 6);
				VtNum = Str2Int(PopWord(&SubStr));
				eofStatus = fgets(buffer, 511, argFP);
				PolyIndex.clear();
				do {
					eofStatus = fgets(buffer, 511, argFP);
					LineStr = buffer;
					if(LineStr.find("vertex") != string::npos) {
						SubStr = LineStr.substr(LineStr.find("vertex") + 7);
						VID = Str2Int(PopWord(&SubStr));
						PolyIndex.push_back(VID + 1);
					}
				} while(LineStr.find("}") == string::npos);
				if(static_cast<int>(PolyIndex.size()) != VtNum) return false;
				else argLIndex->push_back(PolyIndex);
			}
		}

		if(IFFlg == false && LineStr.find("polygons") != string::npos) {
			SubStr = LineStr.substr(LineStr.find("polygons") + 9);
			PolyNum = Str2Int(PopWord(&SubStr));
			IFFlg = true;
			fgets(buffer, 511, argFP);
		}

		eofStatus = fgets(buffer, 511, argFP);
	}

	if(PolyNum != static_cast<int>(argLIndex->size())) {
		return false;
	}
	return true;
}
