<?php
 require_once 'PEAR.php'; require_once 'PEAR/Config.php'; $GLOBALS['_PEAR_DEPENDENCYDB_INSTANCE'] = array(); class PEAR_DependencyDB { var $_config; var $_registry; var $_depdb = false; var $_lockfile = false; var $_lockFp = false; var $_version = '1.0'; var $_cache; function &singleton(&$config, $depdb = false) { $phpdir = $config->get('php_dir', null, 'pear.php.net'); if (!isset($GLOBALS['_PEAR_DEPENDENCYDB_INSTANCE'][$phpdir])) { $a = new PEAR_DependencyDB; $GLOBALS['_PEAR_DEPENDENCYDB_INSTANCE'][$phpdir] = &$a; $a->setConfig($config, $depdb); $e = $a->assertDepsDB(); if (PEAR::isError($e)) { return $e; } } return $GLOBALS['_PEAR_DEPENDENCYDB_INSTANCE'][$phpdir]; } function setConfig(&$config, $depdb = false) { if (!$config) { $this->_config = &PEAR_Config::singleton(); } else { $this->_config = &$config; } $this->_registry = &$this->_config->getRegistry(); if (!$depdb) { $this->_depdb = $this->_config->get('php_dir', null, 'pear.php.net') . DIRECTORY_SEPARATOR . '.depdb'; } else { $this->_depdb = $depdb; } $this->_lockfile = dirname($this->_depdb) . DIRECTORY_SEPARATOR . '.depdblock'; } function hasWriteAccess() { if (!file_exists($this->_depdb)) { $dir = $this->_depdb; while ($dir && $dir != '.') { $dir = dirname($dir); if ($dir != '.' && file_exists($dir)) { if (is_writeable($dir)) { return true; } return false; } } return false; } return is_writeable($this->_depdb); } function assertDepsDB() { if (!is_file($this->_depdb)) { $this->rebuildDB(); return; } $depdb = $this->_getDepDB(); if ($depdb['_version'] < $this->_version) { $this->rebuildDB(); } if ($depdb['_version']{0} > $this->_version{0}) { return PEAR::raiseError('Dependency database is version ' . $depdb['_version'] . ', and we are version ' . $this->_version . ', cannot continue'); } } function getDependentPackages(&$pkg) { $data = $this->_getDepDB(); if (is_object($pkg)) { $channel = strtolower($pkg->getChannel()); $package = strtolower($pkg->getPackage()); } else { $channel = strtolower($pkg['channel']); $package = strtolower($pkg['package']); } if (isset($data['packages'][$channel][$package])) { return $data['packages'][$channel][$package]; } return false; } function getDependentPackageDependencies(&$pkg) { $data = $this->_getDepDB(); if (is_object($pkg)) { $channel = strtolower($pkg->getChannel()); $package = strtolower($pkg->getPackage()); } else { $channel = strtolower($pkg['channel']); $package = strtolower($pkg['package']); } $depend = $this->getDependentPackages($pkg); if (!$depend) { return false; } $dependencies = array(); foreach ($depend as $info) { $temp = $this->getDependencies($info); foreach ($temp as $dep) { if ( isset($dep['dep'], $dep['dep']['channel'], $dep['dep']['name']) && strtolower($dep['dep']['channel']) == $channel && strtolower($dep['dep']['name']) == $package ) { if (!isset($dependencies[$info['channel']])) { $dependencies[$info['channel']] = array(); } if (!isset($dependencies[$info['channel']][$info['package']])) { $dependencies[$info['channel']][$info['package']] = array(); } $dependencies[$info['channel']][$info['package']][] = $dep; } } } return $dependencies; } function getDependencies(&$pkg) { if (is_object($pkg)) { $channel = strtolower($pkg->getChannel()); $package = strtolower($pkg->getPackage()); } else { $channel = strtolower($pkg['channel']); $package = strtolower($pkg['package']); } $data = $this->_getDepDB(); if (isset($data['dependencies'][$channel][$package])) { return $data['dependencies'][$channel][$package]; } return false; } function dependsOn($parent, $child) { $c = array(); $this->_getDepDB(); return $this->_dependsOn($parent, $child, $c); } function _dependsOn($parent, $child, &$checked) { if (is_object($parent)) { $channel = strtolower($parent->getChannel()); $package = strtolower($parent->getPackage()); } else { $channel = strtolower($parent['channel']); $package = strtolower($parent['package']); } if (is_object($child)) { $depchannel = strtolower($child->getChannel()); $deppackage = strtolower($child->getPackage()); } else { $depchannel = strtolower($child['channel']); $deppackage = strtolower($child['package']); } if (isset($checked[$channel][$package][$depchannel][$deppackage])) { return false; } $checked[$channel][$package][$depchannel][$deppackage] = true; if (!isset($this->_cache['dependencies'][$channel][$package])) { return false; } foreach ($this->_cache['dependencies'][$channel][$package] as $info) { if (isset($info['dep']['uri'])) { if (is_object($child)) { if ($info['dep']['uri'] == $child->getURI()) { return true; } } elseif (isset($child['uri'])) { if ($info['dep']['uri'] == $child['uri']) { return true; } } return false; } if (strtolower($info['dep']['channel']) == $depchannel && strtolower($info['dep']['name']) == $deppackage) { return true; } } foreach ($this->_cache['dependencies'][$channel][$package] as $info) { if (isset($info['dep']['uri'])) { if ($this->_dependsOn(array( 'uri' => $info['dep']['uri'], 'package' => $info['dep']['name']), $child, $checked)) { return true; } } else { if ($this->_dependsOn(array( 'channel' => $info['dep']['channel'], 'package' => $info['dep']['name']), $child, $checked)) { return true; } } } return false; } function installPackage(&$package) { $data = $this->_getDepDB(); unset($this->_cache); $this->_setPackageDeps($data, $package); $this->_writeDepDB($data); } function uninstallPackage(&$pkg) { $data = $this->_getDepDB(); unset($this->_cache); if (is_object($pkg)) { $channel = strtolower($pkg->getChannel()); $package = strtolower($pkg->getPackage()); } else { $channel = strtolower($pkg['channel']); $package = strtolower($pkg['package']); } if (!isset($data['dependencies'][$channel][$package])) { return true; } foreach ($data['dependencies'][$channel][$package] as $dep) { $found = false; $depchannel = isset($dep['dep']['uri']) ? '__uri' : strtolower($dep['dep']['channel']); $depname = strtolower($dep['dep']['name']); if (isset($data['packages'][$depchannel][$depname])) { foreach ($data['packages'][$depchannel][$depname] as $i => $info) { if ($info['channel'] == $channel && $info['package'] == $package) { $found = true; break; } } } if ($found) { unset($data['packages'][$depchannel][$depname][$i]); if (!count($data['packages'][$depchannel][$depname])) { unset($data['packages'][$depchannel][$depname]); if (!count($data['packages'][$depchannel])) { unset($data['packages'][$depchannel]); } } else { $data['packages'][$depchannel][$depname] = array_values($data['packages'][$depchannel][$depname]); } } } unset($data['dependencies'][$channel][$package]); if (!count($data['dependencies'][$channel])) { unset($data['dependencies'][$channel]); } if (!count($data['dependencies'])) { unset($data['dependencies']); } if (!count($data['packages'])) { unset($data['packages']); } $this->_writeDepDB($data); } function rebuildDB() { $depdb = array('_version' => $this->_version); if (!$this->hasWriteAccess()) { return $depdb; } $packages = $this->_registry->listAllPackages(); if (PEAR::isError($packages)) { return $packages; } foreach ($packages as $channel => $ps) { foreach ($ps as $package) { $package = $this->_registry->getPackage($package, $channel); if (PEAR::isError($package)) { return $package; } $this->_setPackageDeps($depdb, $package); } } $error = $this->_writeDepDB($depdb); if (PEAR::isError($error)) { return $error; } $this->_cache = $depdb; return true; } function _lock($mode = LOCK_EX) { if (stristr(php_uname(), 'Windows 9')) { return true; } if ($mode != LOCK_UN && is_resource($this->_lockFp)) { return true; } $open_mode = 'w'; if ($mode === LOCK_SH) { if (!file_exists($this->_lockfile)) { touch($this->_lockfile); } elseif (!is_file($this->_lockfile)) { return PEAR::raiseError('could not create Dependency lock file, ' . 'it exists and is not a regular file'); } $open_mode = 'r'; } if (!is_resource($this->_lockFp)) { $this->_lockFp = @fopen($this->_lockfile, $open_mode); } if (!is_resource($this->_lockFp)) { return PEAR::raiseError("could not create Dependency lock file" . (isset($php_errormsg) ? ": " . $php_errormsg : "")); } if (!(int)flock($this->_lockFp, $mode)) { switch ($mode) { case LOCK_SH: $str = 'shared'; break; case LOCK_EX: $str = 'exclusive'; break; case LOCK_UN: $str = 'unlock'; break; default: $str = 'unknown'; break; } return PEAR::raiseError("could not acquire $str lock ($this->_lockfile)"); } return true; } function _unlock() { $ret = $this->_lock(LOCK_UN); if (is_resource($this->_lockFp)) { fclose($this->_lockFp); } $this->_lockFp = null; return $ret; } function _getDepDB() { if (!$this->hasWriteAccess()) { return array('_version' => $this->_version); } if (isset($this->_cache)) { return $this->_cache; } if (!$fp = fopen($this->_depdb, 'r')) { $err = PEAR::raiseError("Could not open dependencies file `".$this->_depdb."'"); return $err; } $rt = get_magic_quotes_runtime(); set_magic_quotes_runtime(0); clearstatcache(); fclose($fp); $data = unserialize(file_get_contents($this->_depdb)); set_magic_quotes_runtime($rt); $this->_cache = $data; return $data; } function _writeDepDB(&$deps) { if (PEAR::isError($e = $this->_lock(LOCK_EX))) { return $e; } if (!$fp = fopen($this->_depdb, 'wb')) { $this->_unlock(); return PEAR::raiseError("Could not open dependencies file `".$this->_depdb."' for writing"); } $rt = get_magic_quotes_runtime(); set_magic_quotes_runtime(0); fwrite($fp, serialize($deps)); set_magic_quotes_runtime($rt); fclose($fp); $this->_unlock(); $this->_cache = $deps; return true; } function _setPackageDeps(&$data, &$pkg) { $pkg->setConfig($this->_config); if ($pkg->getPackagexmlVersion() == '1.0') { $gen = &$pkg->getDefaultGenerator(); $deps = $gen->dependenciesToV2(); } else { $deps = $pkg->getDeps(true); } if (!$deps) { return; } if (!is_array($data)) { $data = array(); } if (!isset($data['dependencies'])) { $data['dependencies'] = array(); } $channel = strtolower($pkg->getChannel()); $package = strtolower($pkg->getPackage()); if (!isset($data['dependencies'][$channel])) { $data['dependencies'][$channel] = array(); } $data['dependencies'][$channel][$package] = array(); if (isset($deps['required']['package'])) { if (!isset($deps['required']['package'][0])) { $deps['required']['package'] = array($deps['required']['package']); } foreach ($deps['required']['package'] as $dep) { $this->_registerDep($data, $pkg, $dep, 'required'); } } if (isset($deps['optional']['package'])) { if (!isset($deps['optional']['package'][0])) { $deps['optional']['package'] = array($deps['optional']['package']); } foreach ($deps['optional']['package'] as $dep) { $this->_registerDep($data, $pkg, $dep, 'optional'); } } if (isset($deps['required']['subpackage'])) { if (!isset($deps['required']['subpackage'][0])) { $deps['required']['subpackage'] = array($deps['required']['subpackage']); } foreach ($deps['required']['subpackage'] as $dep) { $this->_registerDep($data, $pkg, $dep, 'required'); } } if (isset($deps['optional']['subpackage'])) { if (!isset($deps['optional']['subpackage'][0])) { $deps['optional']['subpackage'] = array($deps['optional']['subpackage']); } foreach ($deps['optional']['subpackage'] as $dep) { $this->_registerDep($data, $pkg, $dep, 'optional'); } } if (isset($deps['group'])) { if (!isset($deps['group'][0])) { $deps['group'] = array($deps['group']); } foreach ($deps['group'] as $group) { if (isset($group['package'])) { if (!isset($group['package'][0])) { $group['package'] = array($group['package']); } foreach ($group['package'] as $dep) { $this->_registerDep($data, $pkg, $dep, 'optional', $group['attribs']['name']); } } if (isset($group['subpackage'])) { if (!isset($group['subpackage'][0])) { $group['subpackage'] = array($group['subpackage']); } foreach ($group['subpackage'] as $dep) { $this->_registerDep($data, $pkg, $dep, 'optional', $group['attribs']['name']); } } } } if ($data['dependencies'][$channel][$package] == array()) { unset($data['dependencies'][$channel][$package]); if (!count($data['dependencies'][$channel])) { unset($data['dependencies'][$channel]); } } } function _registerDep(&$data, &$pkg, $dep, $type, $group = false) { $info = array( 'dep' => $dep, 'type' => $type, 'group' => $group ); $dep = array_map('strtolower', $dep); $depchannel = isset($dep['channel']) ? $dep['channel'] : '__uri'; if (!isset($data['dependencies'])) { $data['dependencies'] = array(); } $channel = strtolower($pkg->getChannel()); $package = strtolower($pkg->getPackage()); if (!isset($data['dependencies'][$channel])) { $data['dependencies'][$channel] = array(); } if (!isset($data['dependencies'][$channel][$package])) { $data['dependencies'][$channel][$package] = array(); } $data['dependencies'][$channel][$package][] = $info; if (isset($data['packages'][$depchannel][$dep['name']])) { $found = false; foreach ($data['packages'][$depchannel][$dep['name']] as $i => $p) { if ($p['channel'] == $channel && $p['package'] == $package) { $found = true; break; } } } else { if (!isset($data['packages'])) { $data['packages'] = array(); } if (!isset($data['packages'][$depchannel])) { $data['packages'][$depchannel] = array(); } if (!isset($data['packages'][$depchannel][$dep['name']])) { $data['packages'][$depchannel][$dep['name']] = array(); } $found = false; } if (!$found) { $data['packages'][$depchannel][$dep['name']][] = array( 'channel' => $channel, 'package' => $package ); } } }