<?php
 $GLOBALS['_PEAR_ERRORSTACK_SINGLETON'] = array(); $GLOBALS['_PEAR_ERRORSTACK_DEFAULT_CALLBACK'] = array( '*' => false, ); $GLOBALS['_PEAR_ERRORSTACK_DEFAULT_LOGGER'] = false; $GLOBALS['_PEAR_ERRORSTACK_OVERRIDE_CALLBACK'] = array(); define('PEAR_ERRORSTACK_PUSHANDLOG', 1); define('PEAR_ERRORSTACK_PUSH', 2); define('PEAR_ERRORSTACK_LOG', 3); define('PEAR_ERRORSTACK_IGNORE', 4); define('PEAR_ERRORSTACK_DIE', 5); define('PEAR_ERRORSTACK_ERR_NONCLASS', 1); define('PEAR_ERRORSTACK_ERR_OBJTOSTRING', 2); class PEAR_ErrorStack { var $_errors = array(); var $_errorsByLevel = array(); var $_package; var $_compat = false; var $_msgCallback = false; var $_contextCallback = false; var $_errorCallback = array(); var $_logger = false; var $_errorMsgs = array(); function PEAR_ErrorStack($package, $msgCallback = false, $contextCallback = false, $throwPEAR_Error = false) { $this->_package = $package; $this->setMessageCallback($msgCallback); $this->setContextCallback($contextCallback); $this->_compat = $throwPEAR_Error; } function &singleton($package, $msgCallback = false, $contextCallback = false, $throwPEAR_Error = false, $stackClass = 'PEAR_ErrorStack') { if (isset($GLOBALS['_PEAR_ERRORSTACK_SINGLETON'][$package])) { return $GLOBALS['_PEAR_ERRORSTACK_SINGLETON'][$package]; } if (!class_exists($stackClass)) { if (function_exists('debug_backtrace')) { $trace = debug_backtrace(); } PEAR_ErrorStack::staticPush('PEAR_ErrorStack', PEAR_ERRORSTACK_ERR_NONCLASS, 'exception', array('stackclass' => $stackClass), 'stack class "%stackclass%" is not a valid class name (should be like PEAR_ErrorStack)', false, $trace); } $GLOBALS['_PEAR_ERRORSTACK_SINGLETON'][$package] = new $stackClass($package, $msgCallback, $contextCallback, $throwPEAR_Error); return $GLOBALS['_PEAR_ERRORSTACK_SINGLETON'][$package]; } function _handleError($err) { if ($err['level'] == 'exception') { $message = $err['message']; if (isset($_SERVER['REQUEST_URI'])) { echo '<br />'; } else { echo "\n"; } var_dump($err['context']); die($message); } } function setDefaultLogger(&$log) { if (is_object($log) && method_exists($log, 'log') ) { $GLOBALS['_PEAR_ERRORSTACK_DEFAULT_LOGGER'] = &$log; } elseif (is_callable($log)) { $GLOBALS['_PEAR_ERRORSTACK_DEFAULT_LOGGER'] = &$log; } } function setLogger(&$log) { if (is_object($log) && method_exists($log, 'log') ) { $this->_logger = &$log; } elseif (is_callable($log)) { $this->_logger = &$log; } } function setMessageCallback($msgCallback) { if (!$msgCallback) { $this->_msgCallback = array(&$this, 'getErrorMessage'); } else { if (is_callable($msgCallback)) { $this->_msgCallback = $msgCallback; } } } function getMessageCallback() { return $this->_msgCallback; } function setDefaultCallback($callback = false, $package = false) { if (!is_callable($callback)) { $callback = false; } $package = $package ? $package : '*'; $GLOBALS['_PEAR_ERRORSTACK_DEFAULT_CALLBACK'][$package] = $callback; } function setContextCallback($contextCallback) { if ($contextCallback === null) { return $this->_contextCallback = false; } if (!$contextCallback) { $this->_contextCallback = array(&$this, 'getFileLine'); } else { if (is_callable($contextCallback)) { $this->_contextCallback = $contextCallback; } } } function pushCallback($cb) { array_push($this->_errorCallback, $cb); } function popCallback() { if (!count($this->_errorCallback)) { return false; } return array_pop($this->_errorCallback); } function staticPushCallback($cb) { array_push($GLOBALS['_PEAR_ERRORSTACK_OVERRIDE_CALLBACK'], $cb); } function staticPopCallback() { $ret = array_pop($GLOBALS['_PEAR_ERRORSTACK_OVERRIDE_CALLBACK']); if (!is_array($GLOBALS['_PEAR_ERRORSTACK_OVERRIDE_CALLBACK'])) { $GLOBALS['_PEAR_ERRORSTACK_OVERRIDE_CALLBACK'] = array(); } return $ret; } function push($code, $level = 'error', $params = array(), $msg = false, $repackage = false, $backtrace = false) { $context = false; if ($this->_contextCallback) { if (!$backtrace) { $backtrace = debug_backtrace(); } $context = call_user_func($this->_contextCallback, $code, $params, $backtrace); } $time = explode(' ', microtime()); $time = $time[1] + $time[0]; $err = array( 'code' => $code, 'params' => $params, 'package' => $this->_package, 'level' => $level, 'time' => $time, 'context' => $context, 'message' => $msg, ); if ($repackage) { $err['repackage'] = $repackage; } if ($this->_msgCallback) { $msg = call_user_func_array($this->_msgCallback, array(&$this, $err)); $err['message'] = $msg; } $push = $log = true; $die = false; $callback = $this->staticPopCallback(); if ($callback) { $this->staticPushCallback($callback); } if (!is_callable($callback)) { $callback = $this->popCallback(); if (is_callable($callback)) { $this->pushCallback($callback); } else { $callback = isset($GLOBALS['_PEAR_ERRORSTACK_DEFAULT_CALLBACK'][$this->_package]) ? $GLOBALS['_PEAR_ERRORSTACK_DEFAULT_CALLBACK'][$this->_package] : $GLOBALS['_PEAR_ERRORSTACK_DEFAULT_CALLBACK']['*']; } } if (is_callable($callback)) { switch(call_user_func($callback, $err)){ case PEAR_ERRORSTACK_IGNORE: return $err; break; case PEAR_ERRORSTACK_PUSH: $log = false; break; case PEAR_ERRORSTACK_LOG: $push = false; break; case PEAR_ERRORSTACK_DIE: $die = true; break; } } if ($push) { array_unshift($this->_errors, $err); if (!isset($this->_errorsByLevel[$err['level']])) { $this->_errorsByLevel[$err['level']] = array(); } $this->_errorsByLevel[$err['level']][] = &$this->_errors[0]; } if ($log) { if ($this->_logger || $GLOBALS['_PEAR_ERRORSTACK_DEFAULT_LOGGER']) { $this->_log($err); } } if ($die) { die(); } if ($this->_compat && $push) { return $this->raiseError($msg, $code, null, null, $err); } return $err; } function staticPush($package, $code, $level = 'error', $params = array(), $msg = false, $repackage = false, $backtrace = false) { $s = &PEAR_ErrorStack::singleton($package); if ($s->_contextCallback) { if (!$backtrace) { if (function_exists('debug_backtrace')) { $backtrace = debug_backtrace(); } } } return $s->push($code, $level, $params, $msg, $repackage, $backtrace); } function _log($err) { if ($this->_logger) { $logger = &$this->_logger; } else { $logger = &$GLOBALS['_PEAR_ERRORSTACK_DEFAULT_LOGGER']; } if (is_a($logger, 'Log')) { $levels = array( 'exception' => PEAR_LOG_CRIT, 'alert' => PEAR_LOG_ALERT, 'critical' => PEAR_LOG_CRIT, 'error' => PEAR_LOG_ERR, 'warning' => PEAR_LOG_WARNING, 'notice' => PEAR_LOG_NOTICE, 'info' => PEAR_LOG_INFO, 'debug' => PEAR_LOG_DEBUG); if (isset($levels[$err['level']])) { $level = $levels[$err['level']]; } else { $level = PEAR_LOG_INFO; } $logger->log($err['message'], $level, $err); } else { call_user_func($logger, $err); } } function pop() { $err = @array_shift($this->_errors); if (!is_null($err)) { @array_pop($this->_errorsByLevel[$err['level']]); if (!count($this->_errorsByLevel[$err['level']])) { unset($this->_errorsByLevel[$err['level']]); } } return $err; } function staticPop($package) { if ($package) { if (!isset($GLOBALS['_PEAR_ERRORSTACK_SINGLETON'][$package])) { return false; } return $GLOBALS['_PEAR_ERRORSTACK_SINGLETON'][$package]->pop(); } } function hasErrors($level = false) { if ($level) { return isset($this->_errorsByLevel[$level]); } return count($this->_errors); } function getErrors($purge = false, $level = false) { if (!$purge) { if ($level) { if (!isset($this->_errorsByLevel[$level])) { return array(); } else { return $this->_errorsByLevel[$level]; } } else { return $this->_errors; } } if ($level) { $ret = $this->_errorsByLevel[$level]; foreach ($this->_errorsByLevel[$level] as $i => $unused) { $this->_errorsByLevel[$level][$i] = false; } $this->_errors = array_filter($this->_errors); unset($this->_errorsByLevel[$level]); return $ret; } $ret = $this->_errors; $this->_errors = array(); $this->_errorsByLevel = array(); return $ret; } function staticHasErrors($package = false, $level = false) { if ($package) { if (!isset($GLOBALS['_PEAR_ERRORSTACK_SINGLETON'][$package])) { return false; } return $GLOBALS['_PEAR_ERRORSTACK_SINGLETON'][$package]->hasErrors($level); } foreach ($GLOBALS['_PEAR_ERRORSTACK_SINGLETON'] as $package => $obj) { if ($obj->hasErrors($level)) { return true; } } return false; } function staticGetErrors($purge = false, $level = false, $merge = false, $sortfunc = array('PEAR_ErrorStack', '_sortErrors')) { $ret = array(); if (!is_callable($sortfunc)) { $sortfunc = array('PEAR_ErrorStack', '_sortErrors'); } foreach ($GLOBALS['_PEAR_ERRORSTACK_SINGLETON'] as $package => $obj) { $test = $GLOBALS['_PEAR_ERRORSTACK_SINGLETON'][$package]->getErrors($purge, $level); if ($test) { if ($merge) { $ret = array_merge($ret, $test); } else { $ret[$package] = $test; } } } if ($merge) { usort($ret, $sortfunc); } return $ret; } function _sortErrors($a, $b) { if ($a['time'] == $b['time']) { return 0; } if ($a['time'] < $b['time']) { return 1; } return -1; } function getFileLine($code, $params, $backtrace = null) { if ($backtrace === null) { return false; } $frame = 0; $functionframe = 1; if (!isset($backtrace[1])) { $functionframe = 0; } else { while (isset($backtrace[$functionframe]['function']) && $backtrace[$functionframe]['function'] == 'eval' && isset($backtrace[$functionframe + 1])) { $functionframe++; } } if (isset($backtrace[$frame])) { if (!isset($backtrace[$frame]['file'])) { $frame++; } $funcbacktrace = $backtrace[$functionframe]; $filebacktrace = $backtrace[$frame]; $ret = array('file' => $filebacktrace['file'], 'line' => $filebacktrace['line']); if (strpos($filebacktrace['file'], '(') && preg_match(';^(.*?)\((\d+)\) : (.*?)\\z;', $filebacktrace['file'], $matches)) { $ret['file'] = $matches[1]; $ret['line'] = $matches[2] + 0; } if (isset($funcbacktrace['function']) && isset($backtrace[1])) { if ($funcbacktrace['function'] != 'eval') { if ($funcbacktrace['function'] == '__lambda_func') { $ret['function'] = 'create_function() code'; } else { $ret['function'] = $funcbacktrace['function']; } } } if (isset($funcbacktrace['class']) && isset($backtrace[1])) { $ret['class'] = $funcbacktrace['class']; } return $ret; } return false; } function getErrorMessage(&$stack, $err, $template = false) { if ($template) { $mainmsg = $template; } else { $mainmsg = $stack->getErrorMessageTemplate($err['code']); } $mainmsg = str_replace('%__msg%', $err['message'], $mainmsg); if (is_array($err['params']) && count($err['params'])) { foreach ($err['params'] as $name => $val) { if (is_array($val)) { $val = @implode(', ', $val); } if (is_object($val)) { if (method_exists($val, '__toString')) { $val = $val->__toString(); } else { PEAR_ErrorStack::staticPush('PEAR_ErrorStack', PEAR_ERRORSTACK_ERR_OBJTOSTRING, 'warning', array('obj' => get_class($val)), 'object %obj% passed into getErrorMessage, but has no __toString() method'); $val = 'Object'; } } $mainmsg = str_replace('%' . $name . '%', $val, $mainmsg); } } return $mainmsg; } function getErrorMessageTemplate($code) { if (!isset($this->_errorMsgs[$code])) { return '%__msg%'; } return $this->_errorMsgs[$code]; } function setErrorMessageTemplate($template) { $this->_errorMsgs = $template; } function raiseError() { require_once 'PEAR.php'; $args = func_get_args(); return call_user_func_array(array('PEAR', 'raiseError'), $args); } } $stack = &PEAR_ErrorStack::singleton('PEAR_ErrorStack'); $stack->pushCallback(array('PEAR_ErrorStack', '_handleError')); ?>
