<?php
 require_once 'PEAR/REST.php'; class PEAR_REST_10 { var $_rest; function PEAR_REST_10($config, $options = array()) { $this->_rest = &new PEAR_REST($config, $options); } function getDownloadURL($base, $packageinfo, $prefstate, $installed, $channel = false) { $states = $this->betterStates($prefstate, true); if (!$states) { return PEAR::raiseError('"' . $prefstate . '" is not a valid state'); } $channel = $packageinfo['channel']; $package = $packageinfo['package']; $state = isset($packageinfo['state']) ? $packageinfo['state'] : null; $version = isset($packageinfo['version']) ? $packageinfo['version'] : null; $restFile = $base . 'r/' . strtolower($package) . '/allreleases.xml'; $info = $this->_rest->retrieveData($restFile, false, false, $channel); if (PEAR::isError($info)) { return PEAR::raiseError('No releases available for package "' . $channel . '/' . $package . '"'); } if (!isset($info['r'])) { return false; } $release = $found = false; if (!is_array($info['r']) || !isset($info['r'][0])) { $info['r'] = array($info['r']); } foreach ($info['r'] as $release) { if (!isset($this->_rest->_options['force']) && ($installed && version_compare($release['v'], $installed, '<'))) { continue; } if (isset($state)) { if ($release['s'] == $state) { $found = true; break; } if (in_array($release['s'], $this->betterStates($state), true)) { $found = true; break; } } elseif (isset($version)) { if ($release['v'] == $version) { $found = true; break; } } else { if (in_array($release['s'], $states)) { $found = true; break; } } } return $this->_returnDownloadURL($base, $package, $release, $info, $found, false, $channel); } function getDepDownloadURL($base, $xsdversion, $dependency, $deppackage, $prefstate = 'stable', $installed = false, $channel = false) { $states = $this->betterStates($prefstate, true); if (!$states) { return PEAR::raiseError('"' . $prefstate . '" is not a valid state'); } $channel = $dependency['channel']; $package = $dependency['name']; $state = isset($dependency['state']) ? $dependency['state'] : null; $version = isset($dependency['version']) ? $dependency['version'] : null; $restFile = $base . 'r/' . strtolower($package) . '/allreleases.xml'; $info = $this->_rest->retrieveData($restFile, false, false, $channel); if (PEAR::isError($info)) { return PEAR::raiseError('Package "' . $deppackage['channel'] . '/' . $deppackage['package'] . '" dependency "' . $channel . '/' . $package . '" has no releases'); } if (!is_array($info) || !isset($info['r'])) { return false; } $exclude = array(); $min = $max = $recommended = false; if ($xsdversion == '1.0') { switch ($dependency['rel']) { case 'ge' : $min = $dependency['version']; break; case 'gt' : $min = $dependency['version']; $exclude = array($dependency['version']); break; case 'eq' : $recommended = $dependency['version']; break; case 'lt' : $max = $dependency['version']; $exclude = array($dependency['version']); break; case 'le' : $max = $dependency['version']; break; case 'ne' : $exclude = array($dependency['version']); break; } } else { $min = isset($dependency['min']) ? $dependency['min'] : false; $max = isset($dependency['max']) ? $dependency['max'] : false; $recommended = isset($dependency['recommended']) ? $dependency['recommended'] : false; if (isset($dependency['exclude'])) { if (!isset($dependency['exclude'][0])) { $exclude = array($dependency['exclude']); } } } $release = $found = false; if (!is_array($info['r']) || !isset($info['r'][0])) { $info['r'] = array($info['r']); } foreach ($info['r'] as $release) { if (!isset($this->_rest->_options['force']) && ($installed && version_compare($release['v'], $installed, '<'))) { continue; } if (in_array($release['v'], $exclude)) { continue; } if ($xsdversion == '2.0' && isset($release['co'])) { if (!is_array($release['co']) || !isset($release['co'][0])) { $release['co'] = array($release['co']); } foreach ($release['co'] as $entry) { if (isset($entry['x']) && !is_array($entry['x'])) { $entry['x'] = array($entry['x']); } elseif (!isset($entry['x'])) { $entry['x'] = array(); } if ($entry['c'] == $deppackage['channel'] && strtolower($entry['p']) == strtolower($deppackage['package']) && version_compare($deppackage['version'], $entry['min'], '>=') && version_compare($deppackage['version'], $entry['max'], '<=') && !in_array($release['v'], $entry['x'])) { $recommended = $release['v']; break; } } } if ($recommended) { if ($release['v'] != $recommended) { continue; } else { if (!in_array($release['s'], $states)) { return $this->_returnDownloadURL($base, $package, $release, $info, true, false, $channel); } } } if ($min && version_compare($release['v'], $min, 'lt')) { continue; } if ($max && version_compare($release['v'], $max, 'gt')) { continue; } if ($installed && version_compare($release['v'], $installed, '<')) { continue; } if (in_array($release['s'], $states)) { $found = true; break; } } return $this->_returnDownloadURL($base, $package, $release, $info, $found, false, $channel); } function _returnDownloadURL($base, $package, $release, $info, $found, $phpversion = false, $channel = false) { if (!$found) { $release = $info['r'][0]; } $packageLower = strtolower($package); $pinfo = $this->_rest->retrieveCacheFirst($base . 'p/' . $packageLower . '/' . 'info.xml', false, false, $channel); if (PEAR::isError($pinfo)) { return PEAR::raiseError('Package "' . $package . '" does not have REST info xml available'); } $releaseinfo = $this->_rest->retrieveCacheFirst($base . 'r/' . $packageLower . '/' . $release['v'] . '.xml', false, false, $channel); if (PEAR::isError($releaseinfo)) { return PEAR::raiseError('Package "' . $package . '" Version "' . $release['v'] . '" does not have REST xml available'); } $packagexml = $this->_rest->retrieveCacheFirst($base . 'r/' . $packageLower . '/' . 'deps.' . $release['v'] . '.txt', false, true, $channel); if (PEAR::isError($packagexml)) { return PEAR::raiseError('Package "' . $package . '" Version "' . $release['v'] . '" does not have REST dependency information available'); } $packagexml = unserialize($packagexml); if (!$packagexml) { $packagexml = array(); } $allinfo = $this->_rest->retrieveData($base . 'r/' . $packageLower . '/allreleases.xml', false, false, $channel); if (!is_array($allinfo['r']) || !isset($allinfo['r'][0])) { $allinfo['r'] = array($allinfo['r']); } $compatible = false; foreach ($allinfo['r'] as $release) { if ($release['v'] != $releaseinfo['v']) { continue; } if (!isset($release['co'])) { break; } $compatible = array(); if (!is_array($release['co']) || !isset($release['co'][0])) { $release['co'] = array($release['co']); } foreach ($release['co'] as $entry) { $comp = array(); $comp['name'] = $entry['p']; $comp['channel'] = $entry['c']; $comp['min'] = $entry['min']; $comp['max'] = $entry['max']; if (isset($entry['x']) && !is_array($entry['x'])) { $comp['exclude'] = $entry['x']; } $compatible[] = $comp; } if (count($compatible) == 1) { $compatible = $compatible[0]; } break; } $deprecated = false; if (isset($pinfo['dc']) && isset($pinfo['dp'])) { if (is_array($pinfo['dp'])) { $deprecated = array('channel' => (string) $pinfo['dc'], 'package' => trim($pinfo['dp']['_content'])); } else { $deprecated = array('channel' => (string) $pinfo['dc'], 'package' => trim($pinfo['dp'])); } } $return = array( 'version' => $releaseinfo['v'], 'info' => $packagexml, 'package' => $releaseinfo['p']['_content'], 'stability' => $releaseinfo['st'], 'compatible' => $compatible, 'deprecated' => $deprecated, ); if ($found) { $return['url'] = $releaseinfo['g']; return $return; } $return['php'] = $phpversion; return $return; } function listPackages($base, $channel = false) { $packagelist = $this->_rest->retrieveData($base . 'p/packages.xml', false, false, $channel); if (PEAR::isError($packagelist)) { return $packagelist; } if (!is_array($packagelist) || !isset($packagelist['p'])) { return array(); } if (!is_array($packagelist['p'])) { $packagelist['p'] = array($packagelist['p']); } return $packagelist['p']; } function listCategories($base, $channel = false) { $categories = array(); $packagelist = $this->_rest->retrieveData($base . 'p/packages.xml', false, false, $channel); if (PEAR::isError($packagelist)) { return $packagelist; } if (!is_array($packagelist) || !isset($packagelist['p'])) { $ret = array(); return $ret; } if (!is_array($packagelist['p'])) { $packagelist['p'] = array($packagelist['p']); } PEAR::pushErrorHandling(PEAR_ERROR_RETURN); foreach ($packagelist['p'] as $package) { $inf = $this->_rest->retrieveData($base . 'p/' . strtolower($package) . '/info.xml', false, false, $channel); if (PEAR::isError($inf)) { PEAR::popErrorHandling(); return $inf; } $cat = $inf['ca']['_content']; if (!isset($categories[$cat])) { $categories[$cat] = $inf['ca']; } } return array_values($categories); } function listCategory($base, $category, $info = false, $channel = false) { $packagelist = $this->_rest->retrieveData($base.'c/'.urlencode($category).'/packages.xml', false, false, $channel); if (PEAR::isError($packagelist)) { return $packagelist; } if (!is_array($packagelist) || !isset($packagelist['p'])) { return array(); } if (!is_array($packagelist['p']) || !isset($packagelist['p'][0])) { $packagelist = array($packagelist['p']); } else { $packagelist = $packagelist['p']; } if ($info == true) { PEAR::pushErrorHandling(PEAR_ERROR_RETURN); foreach ($packagelist as $i => $packageitem) { $url = sprintf('%s'.'r/%s/latest.txt', $base, strtolower($packageitem['_content'])); $version = $this->_rest->retrieveData($url, false, false, $channel); if (PEAR::isError($version)) { break; } $url = sprintf('%s'.'r/%s/%s.xml', $base, strtolower($packageitem['_content']), $version); $info = $this->_rest->retrieveData($url, false, false, $channel); if (PEAR::isError($info)) { break; } $packagelist[$i]['info'] = $info; } PEAR::popErrorHandling(); } return $packagelist; } function listAll($base, $dostable, $basic = true, $searchpackage = false, $searchsummary = false, $channel = false) { $packagelist = $this->_rest->retrieveData($base . 'p/packages.xml', false, false, $channel); if (PEAR::isError($packagelist)) { return $packagelist; } if ($this->_rest->config->get('verbose') > 0) { $ui = &PEAR_Frontend::singleton(); $ui->log('Retrieving data...0%', true); } $ret = array(); if (!is_array($packagelist) || !isset($packagelist['p'])) { return $ret; } if (!is_array($packagelist['p'])) { $packagelist['p'] = array($packagelist['p']); } if ($searchpackage && (!$searchsummary || empty($searchpackage))) { $newpackagelist = array(); foreach ($packagelist['p'] as $package) { if (!empty($searchpackage) && stristr($package, $searchpackage) !== false) { $newpackagelist[] = $package; } } $packagelist['p'] = $newpackagelist; } PEAR::pushErrorHandling(PEAR_ERROR_RETURN); $next = .1; foreach ($packagelist['p'] as $progress => $package) { if ($this->_rest->config->get('verbose') > 0) { if ($progress / count($packagelist['p']) >= $next) { if ($next == .5) { $ui->log('50%', false); } else { $ui->log('.', false); } $next += .1; } } if ($basic) { if ($dostable) { $latest = $this->_rest->retrieveData($base . 'r/' . strtolower($package) . '/stable.txt', false, false, $channel); } else { $latest = $this->_rest->retrieveData($base . 'r/' . strtolower($package) . '/latest.txt', false, false, $channel); } if (PEAR::isError($latest)) { $latest = false; } $info = array('stable' => $latest); } else { $inf = $this->_rest->retrieveData($base . 'p/' . strtolower($package) . '/info.xml', false, false, $channel); if (PEAR::isError($inf)) { PEAR::popErrorHandling(); return $inf; } if ($searchpackage) { $found = (!empty($searchpackage) && stristr($package, $searchpackage) !== false); if (!$found && !(isset($searchsummary) && !empty($searchsummary) && (stristr($inf['s'], $searchsummary) !== false || stristr($inf['d'], $searchsummary) !== false))) { continue; }; } $releases = $this->_rest->retrieveData($base . 'r/' . strtolower($package) . '/allreleases.xml', false, false, $channel); if (PEAR::isError($releases)) { continue; } if (!isset($releases['r'][0])) { $releases['r'] = array($releases['r']); } unset($latest); unset($unstable); unset($stable); unset($state); foreach ($releases['r'] as $release) { if (!isset($latest)) { if ($dostable && $release['s'] == 'stable') { $latest = $release['v']; $state = 'stable'; } if (!$dostable) { $latest = $release['v']; $state = $release['s']; } } if (!isset($stable) && $release['s'] == 'stable') { $stable = $release['v']; if (!isset($unstable)) { $unstable = $stable; } } if (!isset($unstable) && $release['s'] != 'stable') { $latest = $unstable = $release['v']; $state = $release['s']; } if (isset($latest) && !isset($state)) { $state = $release['s']; } if (isset($latest) && isset($stable) && isset($unstable)) { break; } } $deps = array(); if (!isset($unstable)) { $unstable = false; $state = 'stable'; if (isset($stable)) { $latest = $unstable = $stable; } } else { $latest = $unstable; } if (!isset($latest)) { $latest = false; } if ($latest) { $d = $this->_rest->retrieveCacheFirst($base . 'r/' . strtolower($package) . '/deps.' . $latest . '.txt', false, false, $channel); if (!PEAR::isError($d)) { $d = unserialize($d); if ($d) { if (isset($d['required'])) { if (!class_exists('PEAR_PackageFile_v2')) { require_once 'PEAR/PackageFile/v2.php'; } if (!isset($pf)) { $pf = new PEAR_PackageFile_v2; } $pf->setDeps($d); $tdeps = $pf->getDeps(); } else { $tdeps = $d; } foreach ($tdeps as $dep) { if ($dep['type'] !== 'pkg') { continue; } $deps[] = $dep; } } } } if (!isset($stable)) { $stable = '-n/a-'; } if (!$searchpackage) { $info = array('stable' => $latest, 'summary' => $inf['s'], 'description' => $inf['d'], 'deps' => $deps, 'category' => $inf['ca']['_content'], 'unstable' => $unstable, 'state' => $state); } else { $info = array('stable' => $stable, 'summary' => $inf['s'], 'description' => $inf['d'], 'deps' => $deps, 'category' => $inf['ca']['_content'], 'unstable' => $unstable, 'state' => $state); } } $ret[$package] = $info; } PEAR::popErrorHandling(); return $ret; } function listLatestUpgrades($base, $pref_state, $installed, $channel, &$reg) { $packagelist = $this->_rest->retrieveData($base . 'p/packages.xml', false, false, $channel); if (PEAR::isError($packagelist)) { return $packagelist; } $ret = array(); if (!is_array($packagelist) || !isset($packagelist['p'])) { return $ret; } if (!is_array($packagelist['p'])) { $packagelist['p'] = array($packagelist['p']); } foreach ($packagelist['p'] as $package) { if (!isset($installed[strtolower($package)])) { continue; } $inst_version = $reg->packageInfo($package, 'version', $channel); $inst_state = $reg->packageInfo($package, 'release_state', $channel); PEAR::pushErrorHandling(PEAR_ERROR_RETURN); $info = $this->_rest->retrieveData($base . 'r/' . strtolower($package) . '/allreleases.xml', false, false, $channel); PEAR::popErrorHandling(); if (PEAR::isError($info)) { continue; } if (!isset($info['r'])) { continue; } $release = $found = false; if (!is_array($info['r']) || !isset($info['r'][0])) { $info['r'] = array($info['r']); } usort($info['r'], array($this, '_sortReleasesByVersionNumber')); foreach ($info['r'] as $release) { if ($inst_version && version_compare($release['v'], $inst_version, '<=')) { break; } if (!$pref_state) { $found = true; break; } else { $new_state = $release['s']; if (in_array($new_state, $this->betterStates($inst_state, true))) { $found = true; break; } else { if (in_array($new_state, $this->betterStates($pref_state, true))) { $found = true; break; } } } } if (!$found) { continue; } $relinfo = $this->_rest->retrieveCacheFirst($base . 'r/' . strtolower($package) . '/' . $release['v'] . '.xml', false, false, $channel); if (PEAR::isError($relinfo)) { return $relinfo; } $ret[$package] = array( 'version' => $release['v'], 'state' => $release['s'], 'filesize' => $relinfo['f'], ); } return $ret; } function packageInfo($base, $package, $channel = false) { PEAR::pushErrorHandling(PEAR_ERROR_RETURN); $pinfo = $this->_rest->retrieveData($base . 'p/' . strtolower($package) . '/info.xml', false, false, $channel); if (PEAR::isError($pinfo)) { PEAR::popErrorHandling(); return PEAR::raiseError('Unknown package: "' . $package . '" in channel "' . $channel . '"' . "\n". 'Debug: ' . $pinfo->getMessage()); } $releases = array(); $allreleases = $this->_rest->retrieveData($base . 'r/' . strtolower($package) . '/allreleases.xml', false, false, $channel); if (!PEAR::isError($allreleases)) { if (!class_exists('PEAR_PackageFile_v2')) { require_once 'PEAR/PackageFile/v2.php'; } if (!is_array($allreleases['r']) || !isset($allreleases['r'][0])) { $allreleases['r'] = array($allreleases['r']); } $pf = new PEAR_PackageFile_v2; foreach ($allreleases['r'] as $release) { $ds = $this->_rest->retrieveCacheFirst($base . 'r/' . strtolower($package) . '/deps.' . $release['v'] . '.txt', false, false, $channel); if (PEAR::isError($ds)) { continue; } if (!isset($latest)) { $latest = $release['v']; } $pf->setDeps(unserialize($ds)); $ds = $pf->getDeps(); $info = $this->_rest->retrieveCacheFirst($base . 'r/' . strtolower($package) . '/' . $release['v'] . '.xml', false, false, $channel); if (PEAR::isError($info)) { continue; } $releases[$release['v']] = array( 'doneby' => $info['m'], 'license' => $info['l'], 'summary' => $info['s'], 'description' => $info['d'], 'releasedate' => $info['da'], 'releasenotes' => $info['n'], 'state' => $release['s'], 'deps' => $ds ? $ds : array(), ); } } else { $latest = ''; } PEAR::popErrorHandling(); if (isset($pinfo['dc']) && isset($pinfo['dp'])) { if (is_array($pinfo['dp'])) { $deprecated = array('channel' => (string) $pinfo['dc'], 'package' => trim($pinfo['dp']['_content'])); } else { $deprecated = array('channel' => (string) $pinfo['dc'], 'package' => trim($pinfo['dp'])); } } else { $deprecated = false; } if (!isset($latest)) { $latest = ''; } return array( 'name' => $pinfo['n'], 'channel' => $pinfo['c'], 'category' => $pinfo['ca']['_content'], 'stable' => $latest, 'license' => $pinfo['l'], 'summary' => $pinfo['s'], 'description' => $pinfo['d'], 'releases' => $releases, 'deprecated' => $deprecated, ); } function betterStates($state, $include = false) { static $states = array('snapshot', 'devel', 'alpha', 'beta', 'stable'); $i = array_search($state, $states); if ($i === false) { return false; } if ($include) { $i--; } return array_slice($states, $i + 1); } function _sortReleasesByVersionNumber($a, $b) { if (version_compare($a['v'], $b['v'], '=')) { return 0; } if (version_compare($a['v'], $b['v'], '>')) { return -1; } if (version_compare($a['v'], $b['v'], '<')) { return 1; } } }